/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.common.escape;

import org.apache.hbase.thirdparty.com.google.common.annotations.Beta;
import org.apache.hbase.thirdparty.com.google.common.annotations.GwtCompatible;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.escape.Escaper;
import org.apache.hbase.thirdparty.com.google.common.escape.Platform;

@Beta
@GwtCompatible
public abstract class UnicodeEscaper
extends Escaper {
    private static final int DEST_PAD = 32;

    protected UnicodeEscaper() {
    }

    protected abstract char[] escape(int var1);

    @Override
    public String escape(String string2) {
        Preconditions.checkNotNull(string2);
        int end2 = string2.length();
        int index2 = this.nextEscapeIndex(string2, 0, end2);
        return index2 == end2 ? string2 : this.escapeSlow(string2, index2);
    }

    protected int nextEscapeIndex(CharSequence csq, int start2, int end2) {
        int index2;
        int cp;
        for (index2 = start2; index2 < end2 && (cp = UnicodeEscaper.codePointAt(csq, index2, end2)) >= 0 && this.escape(cp) == null; index2 += Character.isSupplementaryCodePoint(cp) ? 2 : 1) {
        }
        return index2;
    }

    protected final String escapeSlow(String s2, int index2) {
        int end2 = s2.length();
        char[] dest = Platform.charBufferFromThreadLocal();
        int destIndex = 0;
        int unescapedChunkStart = 0;
        while (index2 < end2) {
            int cp = UnicodeEscaper.codePointAt(s2, index2, end2);
            if (cp < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] escaped = this.escape(cp);
            int nextIndex = index2 + (Character.isSupplementaryCodePoint(cp) ? 2 : 1);
            if (escaped != null) {
                int charsSkipped = index2 - unescapedChunkStart;
                int sizeNeeded = destIndex + charsSkipped + escaped.length;
                if (dest.length < sizeNeeded) {
                    int destLength = sizeNeeded + (end2 - index2) + 32;
                    dest = UnicodeEscaper.growBuffer(dest, destIndex, destLength);
                }
                if (charsSkipped > 0) {
                    s2.getChars(unescapedChunkStart, index2, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (escaped.length > 0) {
                    System.arraycopy(escaped, 0, dest, destIndex, escaped.length);
                    destIndex += escaped.length;
                }
                unescapedChunkStart = nextIndex;
            }
            index2 = this.nextEscapeIndex(s2, nextIndex, end2);
        }
        int charsSkipped = end2 - unescapedChunkStart;
        if (charsSkipped > 0) {
            int endIndex = destIndex + charsSkipped;
            if (dest.length < endIndex) {
                dest = UnicodeEscaper.growBuffer(dest, destIndex, endIndex);
            }
            s2.getChars(unescapedChunkStart, end2, dest, destIndex);
            destIndex = endIndex;
        }
        return new String(dest, 0, destIndex);
    }

    protected static int codePointAt(CharSequence seq, int index2, int end2) {
        Preconditions.checkNotNull(seq);
        if (index2 < end2) {
            char c1;
            if ((c1 = seq.charAt(index2++)) < '\ud800' || c1 > '\udfff') {
                return c1;
            }
            if (c1 <= '\udbff') {
                if (index2 == end2) {
                    return -c1;
                }
                char c2 = seq.charAt(index2);
                if (Character.isLowSurrogate(c2)) {
                    return Character.toCodePoint(c1, c2);
                }
                char c = c2;
                int n = index2;
                String string2 = String.valueOf(seq);
                throw new IllegalArgumentException(new StringBuilder(89 + String.valueOf(string2).length()).append("Expected low surrogate but got char '").append(c2).append("' with value ").append((int)c).append(" at index ").append(n).append(" in '").append(string2).append("'").toString());
            }
            char c = c1;
            int n = index2 - 1;
            String string3 = String.valueOf(seq);
            throw new IllegalArgumentException(new StringBuilder(88 + String.valueOf(string3).length()).append("Unexpected low surrogate character '").append(c1).append("' with value ").append((int)c).append(" at index ").append(n).append(" in '").append(string3).append("'").toString());
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static char[] growBuffer(char[] dest, int index2, int size2) {
        if (size2 < 0) {
            throw new AssertionError((Object)"Cannot increase internal buffer any further");
        }
        char[] copy = new char[size2];
        if (index2 > 0) {
            System.arraycopy(dest, 0, copy, 0, index2);
        }
        return copy;
    }
}

