/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;
import org.apache.hbase.thirdparty.com.google.protobuf.AbstractProtobufList;
import org.apache.hbase.thirdparty.com.google.protobuf.Internal;
import org.apache.hbase.thirdparty.com.google.protobuf.PrimitiveNonBoxingCollection;

final class IntArrayList
extends AbstractProtobufList<Integer>
implements Internal.IntList,
RandomAccess,
PrimitiveNonBoxingCollection {
    private static final IntArrayList EMPTY_LIST = new IntArrayList(new int[0], 0);
    private int[] array;
    private int size;

    public static IntArrayList emptyList() {
        return EMPTY_LIST;
    }

    IntArrayList() {
        this(new int[10], 0);
    }

    private IntArrayList(int[] other, int size2) {
        this.array = other;
        this.size = size2;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.ensureIsMutable();
        if (toIndex < fromIndex) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.array, toIndex, this.array, fromIndex, this.size - toIndex);
        this.size -= toIndex - fromIndex;
        ++this.modCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntArrayList)) {
            return super.equals(o);
        }
        IntArrayList other = (IntArrayList)o;
        if (this.size != other.size) {
            return false;
        }
        int[] arr = other.array;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.array[i2] == arr[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            result2 = 31 * result2 + this.array[i2];
        }
        return result2;
    }

    @Override
    public Internal.IntList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size) {
            throw new IllegalArgumentException();
        }
        return new IntArrayList(Arrays.copyOf(this.array, capacity), this.size);
    }

    @Override
    public Integer get(int index2) {
        return this.getInt(index2);
    }

    @Override
    public int getInt(int index2) {
        this.ensureIndexInRange(index2);
        return this.array[index2];
    }

    @Override
    public int indexOf(Object element) {
        if (!(element instanceof Integer)) {
            return -1;
        }
        int unboxedElement = (Integer)element;
        int numElems = this.size();
        for (int i2 = 0; i2 < numElems; ++i2) {
            if (this.array[i2] != unboxedElement) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Integer set(int index2, Integer element) {
        return this.setInt(index2, element);
    }

    @Override
    public int setInt(int index2, int element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        int previousValue = this.array[index2];
        this.array[index2] = element;
        return previousValue;
    }

    @Override
    public boolean add(Integer element) {
        this.addInt(element);
        return true;
    }

    @Override
    public void add(int index2, Integer element) {
        this.addInt(index2, element);
    }

    @Override
    public void addInt(int element) {
        this.ensureIsMutable();
        if (this.size == this.array.length) {
            int length2 = this.size * 3 / 2 + 1;
            int[] newArray = new int[length2];
            System.arraycopy(this.array, 0, newArray, 0, this.size);
            this.array = newArray;
        }
        this.array[this.size++] = element;
    }

    private void addInt(int index2, int element) {
        this.ensureIsMutable();
        if (index2 < 0 || index2 > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index2, this.array, index2 + 1, this.size - index2);
        } else {
            int length2 = this.size * 3 / 2 + 1;
            int[] newArray = new int[length2];
            System.arraycopy(this.array, 0, newArray, 0, index2);
            System.arraycopy(this.array, index2, newArray, index2 + 1, this.size - index2);
            this.array = newArray;
        }
        this.array[index2] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        this.ensureIsMutable();
        Internal.checkNotNull(collection);
        if (!(collection instanceof IntArrayList)) {
            return super.addAll(collection);
        }
        IntArrayList list2 = (IntArrayList)collection;
        if (list2.size == 0) {
            return false;
        }
        int overflow = Integer.MAX_VALUE - this.size;
        if (overflow < list2.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list2.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list2.array, 0, this.array, this.size, list2.size);
        this.size = newSize;
        ++this.modCount;
        return true;
    }

    @Override
    public Integer remove(int index2) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index2);
        int value2 = this.array[index2];
        if (index2 < this.size - 1) {
            System.arraycopy(this.array, index2 + 1, this.array, index2, this.size - index2 - 1);
        }
        --this.size;
        ++this.modCount;
        return value2;
    }

    private void ensureIndexInRange(int index2) {
        if (index2 < 0 || index2 >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index2));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index2) {
        return "Index:" + index2 + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

