/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import org.apache.hbase.thirdparty.com.google.protobuf.MessageInfo;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageLite;
import org.apache.hbase.thirdparty.com.google.protobuf.ProtoSyntax;

final class RawMessageInfo
implements MessageInfo {
    private final MessageLite defaultInstance;
    private final String info;
    private final Object[] objects;
    private final int flags;

    RawMessageInfo(MessageLite defaultInstance, String info, Object[] objects) {
        char value2;
        this.defaultInstance = defaultInstance;
        this.info = info;
        this.objects = objects;
        try {
            value2 = info.charAt(0);
        }
        catch (StringIndexOutOfBoundsException e) {
            char[] infoChars = info.toCharArray();
            info = new String(infoChars);
            try {
                value2 = info.charAt(0);
            }
            catch (StringIndexOutOfBoundsException e2) {
                try {
                    char[] infoChars2 = new char[info.length()];
                    info.getChars(0, info.length(), infoChars2, 0);
                    info = new String(infoChars2);
                    value2 = info.charAt(0);
                }
                catch (ArrayIndexOutOfBoundsException | StringIndexOutOfBoundsException e3) {
                    throw new IllegalStateException(String.format("Failed parsing '%s' with charArray.length of %d", info, infoChars.length), e3);
                }
            }
        }
        int position = 1;
        if (value2 < '\ud800') {
            this.flags = value2;
        } else {
            int result2 = value2 & 0x1FFF;
            int shift2 = 13;
            while ((value2 = info.charAt(position++)) >= '\ud800') {
                result2 |= (value2 & 0x1FFF) << shift2;
                shift2 += 13;
            }
            this.flags = result2 | value2 << shift2;
        }
    }

    String getStringInfo() {
        return this.info;
    }

    Object[] getObjects() {
        return this.objects;
    }

    @Override
    public MessageLite getDefaultInstance() {
        return this.defaultInstance;
    }

    @Override
    public ProtoSyntax getSyntax() {
        return (this.flags & 1) == 1 ? ProtoSyntax.PROTO2 : ProtoSyntax.PROTO3;
    }

    @Override
    public boolean isMessageSetWireFormat() {
        return (this.flags & 2) == 2;
    }
}

