/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageLiteToString;
import org.apache.hbase.thirdparty.com.google.protobuf.WireFormat;
import org.apache.hbase.thirdparty.com.google.protobuf.Writer;

public final class UnknownFieldSetLite {
    private static final int MIN_CAPACITY = 8;
    private static final UnknownFieldSetLite DEFAULT_INSTANCE = new UnknownFieldSetLite(0, new int[0], new Object[0], false);
    private int count;
    private int[] tags;
    private Object[] objects;
    private int memoizedSerializedSize = -1;
    private boolean isMutable;

    public static UnknownFieldSetLite getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    static UnknownFieldSetLite newInstance() {
        return new UnknownFieldSetLite();
    }

    static UnknownFieldSetLite mutableCopyOf(UnknownFieldSetLite first2, UnknownFieldSetLite second) {
        int count2 = first2.count + second.count;
        int[] tags = Arrays.copyOf(first2.tags, count2);
        System.arraycopy(second.tags, 0, tags, first2.count, second.count);
        Object[] objects = Arrays.copyOf(first2.objects, count2);
        System.arraycopy(second.objects, 0, objects, first2.count, second.count);
        return new UnknownFieldSetLite(count2, tags, objects, true);
    }

    private UnknownFieldSetLite() {
        this(0, new int[8], new Object[8], true);
    }

    private UnknownFieldSetLite(int count2, int[] tags, Object[] objects, boolean isMutable) {
        this.count = count2;
        this.tags = tags;
        this.objects = objects;
        this.isMutable = isMutable;
    }

    public void makeImmutable() {
        this.isMutable = false;
    }

    void checkMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        block7: for (int i2 = 0; i2 < this.count; ++i2) {
            int tag2 = this.tags[i2];
            int fieldNumber = WireFormat.getTagFieldNumber(tag2);
            switch (WireFormat.getTagWireType(tag2)) {
                case 0: {
                    output.writeUInt64(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 5: {
                    output.writeFixed32(fieldNumber, (Integer)this.objects[i2]);
                    continue block7;
                }
                case 1: {
                    output.writeFixed64(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 2: {
                    output.writeBytes(fieldNumber, (ByteString)this.objects[i2]);
                    continue block7;
                }
                case 3: {
                    output.writeTag(fieldNumber, 3);
                    ((UnknownFieldSetLite)this.objects[i2]).writeTo(output);
                    output.writeTag(fieldNumber, 4);
                    continue block7;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
    }

    public void writeAsMessageSetTo(CodedOutputStream output) throws IOException {
        for (int i2 = 0; i2 < this.count; ++i2) {
            int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i2]);
            output.writeRawMessageSetExtension(fieldNumber, (ByteString)this.objects[i2]);
        }
    }

    void writeAsMessageSetTo(Writer writer) throws IOException {
        if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            for (int i2 = this.count - 1; i2 >= 0; --i2) {
                int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i2]);
                writer.writeMessageSetItem(fieldNumber, this.objects[i2]);
            }
        } else {
            for (int i3 = 0; i3 < this.count; ++i3) {
                int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i3]);
                writer.writeMessageSetItem(fieldNumber, this.objects[i3]);
            }
        }
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.count == 0) {
            return;
        }
        if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
            for (int i2 = 0; i2 < this.count; ++i2) {
                UnknownFieldSetLite.writeField(this.tags[i2], this.objects[i2], writer);
            }
        } else {
            for (int i3 = this.count - 1; i3 >= 0; --i3) {
                UnknownFieldSetLite.writeField(this.tags[i3], this.objects[i3], writer);
            }
        }
    }

    private static void writeField(int tag2, Object object, Writer writer) throws IOException {
        int fieldNumber = WireFormat.getTagFieldNumber(tag2);
        switch (WireFormat.getTagWireType(tag2)) {
            case 0: {
                writer.writeInt64(fieldNumber, (Long)object);
                break;
            }
            case 5: {
                writer.writeFixed32(fieldNumber, (Integer)object);
                break;
            }
            case 1: {
                writer.writeFixed64(fieldNumber, (Long)object);
                break;
            }
            case 2: {
                writer.writeBytes(fieldNumber, (ByteString)object);
                break;
            }
            case 3: {
                if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
                    writer.writeStartGroup(fieldNumber);
                    ((UnknownFieldSetLite)object).writeTo(writer);
                    writer.writeEndGroup(fieldNumber);
                    break;
                }
                writer.writeEndGroup(fieldNumber);
                ((UnknownFieldSetLite)object).writeTo(writer);
                writer.writeStartGroup(fieldNumber);
                break;
            }
            default: {
                throw new RuntimeException(InvalidProtocolBufferException.invalidWireType());
            }
        }
    }

    public int getSerializedSizeAsMessageSet() {
        int size2 = this.memoizedSerializedSize;
        if (size2 != -1) {
            return size2;
        }
        size2 = 0;
        for (int i2 = 0; i2 < this.count; ++i2) {
            int tag2 = this.tags[i2];
            int fieldNumber = WireFormat.getTagFieldNumber(tag2);
            size2 += CodedOutputStream.computeRawMessageSetExtensionSize(fieldNumber, (ByteString)this.objects[i2]);
        }
        this.memoizedSerializedSize = size2;
        return size2;
    }

    public int getSerializedSize() {
        int size2 = this.memoizedSerializedSize;
        if (size2 != -1) {
            return size2;
        }
        size2 = 0;
        block7: for (int i2 = 0; i2 < this.count; ++i2) {
            int tag2 = this.tags[i2];
            int fieldNumber = WireFormat.getTagFieldNumber(tag2);
            switch (WireFormat.getTagWireType(tag2)) {
                case 0: {
                    size2 += CodedOutputStream.computeUInt64Size(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 5: {
                    size2 += CodedOutputStream.computeFixed32Size(fieldNumber, (Integer)this.objects[i2]);
                    continue block7;
                }
                case 1: {
                    size2 += CodedOutputStream.computeFixed64Size(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 2: {
                    size2 += CodedOutputStream.computeBytesSize(fieldNumber, (ByteString)this.objects[i2]);
                    continue block7;
                }
                case 3: {
                    size2 += CodedOutputStream.computeTagSize(fieldNumber) * 2 + ((UnknownFieldSetLite)this.objects[i2]).getSerializedSize();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(InvalidProtocolBufferException.invalidWireType());
                }
            }
        }
        this.memoizedSerializedSize = size2;
        return size2;
    }

    private static boolean tagsEquals(int[] tags1, int[] tags2, int count2) {
        for (int i2 = 0; i2 < count2; ++i2) {
            if (tags1[i2] == tags2[i2]) continue;
            return false;
        }
        return true;
    }

    private static boolean objectsEquals(Object[] objects1, Object[] objects2, int count2) {
        for (int i2 = 0; i2 < count2; ++i2) {
            if (objects1[i2].equals(objects2[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnknownFieldSetLite)) {
            return false;
        }
        UnknownFieldSetLite other = (UnknownFieldSetLite)obj;
        return this.count == other.count && UnknownFieldSetLite.tagsEquals(this.tags, other.tags, this.count) && UnknownFieldSetLite.objectsEquals(this.objects, other.objects, this.count);
    }

    private static int hashCode(int[] tags, int count2) {
        int hashCode = 17;
        for (int i2 = 0; i2 < count2; ++i2) {
            hashCode = 31 * hashCode + tags[i2];
        }
        return hashCode;
    }

    private static int hashCode(Object[] objects, int count2) {
        int hashCode = 17;
        for (int i2 = 0; i2 < count2; ++i2) {
            hashCode = 31 * hashCode + objects[i2].hashCode();
        }
        return hashCode;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 31 * hashCode + this.count;
        hashCode = 31 * hashCode + UnknownFieldSetLite.hashCode(this.tags, this.count);
        hashCode = 31 * hashCode + UnknownFieldSetLite.hashCode(this.objects, this.count);
        return hashCode;
    }

    final void printWithIndent(StringBuilder buffer, int indent) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i2]);
            MessageLiteToString.printField(buffer, indent, String.valueOf(fieldNumber), this.objects[i2]);
        }
    }

    void storeField(int tag2, Object value2) {
        this.checkMutable();
        this.ensureCapacity();
        this.tags[this.count] = tag2;
        this.objects[this.count] = value2;
        ++this.count;
    }

    private void ensureCapacity() {
        if (this.count == this.tags.length) {
            int increment = this.count < 4 ? 8 : this.count >> 1;
            int newLength = this.count + increment;
            this.tags = Arrays.copyOf(this.tags, newLength);
            this.objects = Arrays.copyOf(this.objects, newLength);
        }
    }

    boolean mergeFieldFrom(int tag2, CodedInputStream input) throws IOException {
        this.checkMutable();
        int fieldNumber = WireFormat.getTagFieldNumber(tag2);
        switch (WireFormat.getTagWireType(tag2)) {
            case 0: {
                this.storeField(tag2, input.readInt64());
                return true;
            }
            case 5: {
                this.storeField(tag2, input.readFixed32());
                return true;
            }
            case 1: {
                this.storeField(tag2, input.readFixed64());
                return true;
            }
            case 2: {
                this.storeField(tag2, input.readBytes());
                return true;
            }
            case 3: {
                UnknownFieldSetLite subFieldSet = new UnknownFieldSetLite();
                subFieldSet.mergeFrom(input);
                input.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
                this.storeField(tag2, subFieldSet);
                return true;
            }
            case 4: {
                return false;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    UnknownFieldSetLite mergeVarintField(int fieldNumber, int value2) {
        this.checkMutable();
        if (fieldNumber == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag(fieldNumber, 0), value2);
        return this;
    }

    UnknownFieldSetLite mergeLengthDelimitedField(int fieldNumber, ByteString value2) {
        this.checkMutable();
        if (fieldNumber == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag(fieldNumber, 2), value2);
        return this;
    }

    private UnknownFieldSetLite mergeFrom(CodedInputStream input) throws IOException {
        int tag2;
        while ((tag2 = input.readTag()) != 0 && this.mergeFieldFrom(tag2, input)) {
        }
        return this;
    }
}

