/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import org.apache.hbase.thirdparty.io.netty.buffer.AbstractDerivedByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.DuplicatedByteBuf;
import org.apache.hbase.thirdparty.io.netty.util.ByteProcessor;
import org.apache.hbase.thirdparty.io.netty.util.internal.MathUtil;

abstract class AbstractUnpooledSlicedByteBuf
extends AbstractDerivedByteBuf {
    private final ByteBuf buffer;
    private final int adjustment;

    AbstractUnpooledSlicedByteBuf(ByteBuf buffer, int index2, int length2) {
        super(length2);
        AbstractUnpooledSlicedByteBuf.checkSliceOutOfBounds(index2, length2, buffer);
        if (buffer instanceof AbstractUnpooledSlicedByteBuf) {
            this.buffer = ((AbstractUnpooledSlicedByteBuf)buffer).buffer;
            this.adjustment = ((AbstractUnpooledSlicedByteBuf)buffer).adjustment + index2;
        } else if (buffer instanceof DuplicatedByteBuf) {
            this.buffer = buffer.unwrap();
            this.adjustment = index2;
        } else {
            this.buffer = buffer;
            this.adjustment = index2;
        }
        this.initLength(length2);
        this.writerIndex(length2);
    }

    void initLength(int length2) {
    }

    int length() {
        return this.capacity();
    }

    @Override
    public ByteBuf unwrap() {
        return this.buffer;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.unwrap().alloc();
    }

    @Override
    @Deprecated
    public ByteOrder order() {
        return this.unwrap().order();
    }

    @Override
    public boolean isDirect() {
        return this.unwrap().isDirect();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public boolean hasArray() {
        return this.unwrap().hasArray();
    }

    @Override
    public byte[] array() {
        return this.unwrap().array();
    }

    @Override
    public int arrayOffset() {
        return this.idx(this.unwrap().arrayOffset());
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.unwrap().hasMemoryAddress();
    }

    @Override
    public long memoryAddress() {
        return this.unwrap().memoryAddress() + (long)this.adjustment;
    }

    @Override
    public byte getByte(int index2) {
        this.checkIndex0(index2, 1);
        return this.unwrap().getByte(this.idx(index2));
    }

    @Override
    protected byte _getByte(int index2) {
        return this.unwrap().getByte(this.idx(index2));
    }

    @Override
    public short getShort(int index2) {
        this.checkIndex0(index2, 2);
        return this.unwrap().getShort(this.idx(index2));
    }

    @Override
    protected short _getShort(int index2) {
        return this.unwrap().getShort(this.idx(index2));
    }

    @Override
    public short getShortLE(int index2) {
        this.checkIndex0(index2, 2);
        return this.unwrap().getShortLE(this.idx(index2));
    }

    @Override
    protected short _getShortLE(int index2) {
        return this.unwrap().getShortLE(this.idx(index2));
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.checkIndex0(index2, 3);
        return this.unwrap().getUnsignedMedium(this.idx(index2));
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return this.unwrap().getUnsignedMedium(this.idx(index2));
    }

    @Override
    public int getUnsignedMediumLE(int index2) {
        this.checkIndex0(index2, 3);
        return this.unwrap().getUnsignedMediumLE(this.idx(index2));
    }

    @Override
    protected int _getUnsignedMediumLE(int index2) {
        return this.unwrap().getUnsignedMediumLE(this.idx(index2));
    }

    @Override
    public int getInt(int index2) {
        this.checkIndex0(index2, 4);
        return this.unwrap().getInt(this.idx(index2));
    }

    @Override
    protected int _getInt(int index2) {
        return this.unwrap().getInt(this.idx(index2));
    }

    @Override
    public int getIntLE(int index2) {
        this.checkIndex0(index2, 4);
        return this.unwrap().getIntLE(this.idx(index2));
    }

    @Override
    protected int _getIntLE(int index2) {
        return this.unwrap().getIntLE(this.idx(index2));
    }

    @Override
    public long getLong(int index2) {
        this.checkIndex0(index2, 8);
        return this.unwrap().getLong(this.idx(index2));
    }

    @Override
    protected long _getLong(int index2) {
        return this.unwrap().getLong(this.idx(index2));
    }

    @Override
    public long getLongLE(int index2) {
        this.checkIndex0(index2, 8);
        return this.unwrap().getLongLE(this.idx(index2));
    }

    @Override
    protected long _getLongLE(int index2) {
        return this.unwrap().getLongLE(this.idx(index2));
    }

    @Override
    public ByteBuf duplicate() {
        return this.unwrap().duplicate().setIndex(this.idx(this.readerIndex()), this.idx(this.writerIndex()));
    }

    @Override
    public ByteBuf copy(int index2, int length2) {
        this.checkIndex0(index2, length2);
        return this.unwrap().copy(this.idx(index2), length2);
    }

    @Override
    public ByteBuf slice(int index2, int length2) {
        this.checkIndex0(index2, length2);
        return this.unwrap().slice(this.idx(index2), length2);
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length2) {
        this.checkIndex0(index2, length2);
        this.unwrap().getBytes(this.idx(index2), dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length2) {
        this.checkIndex0(index2, length2);
        this.unwrap().getBytes(this.idx(index2), dst, dstIndex, length2);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.checkIndex0(index2, dst.remaining());
        this.unwrap().getBytes(this.idx(index2), dst);
        return this;
    }

    @Override
    public ByteBuf setByte(int index2, int value2) {
        this.checkIndex0(index2, 1);
        this.unwrap().setByte(this.idx(index2), value2);
        return this;
    }

    @Override
    public CharSequence getCharSequence(int index2, int length2, Charset charset) {
        this.checkIndex0(index2, length2);
        return this.unwrap().getCharSequence(this.idx(index2), length2, charset);
    }

    @Override
    protected void _setByte(int index2, int value2) {
        this.unwrap().setByte(this.idx(index2), value2);
    }

    @Override
    public ByteBuf setShort(int index2, int value2) {
        this.checkIndex0(index2, 2);
        this.unwrap().setShort(this.idx(index2), value2);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value2) {
        this.unwrap().setShort(this.idx(index2), value2);
    }

    @Override
    public ByteBuf setShortLE(int index2, int value2) {
        this.checkIndex0(index2, 2);
        this.unwrap().setShortLE(this.idx(index2), value2);
        return this;
    }

    @Override
    protected void _setShortLE(int index2, int value2) {
        this.unwrap().setShortLE(this.idx(index2), value2);
    }

    @Override
    public ByteBuf setMedium(int index2, int value2) {
        this.checkIndex0(index2, 3);
        this.unwrap().setMedium(this.idx(index2), value2);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        this.unwrap().setMedium(this.idx(index2), value2);
    }

    @Override
    public ByteBuf setMediumLE(int index2, int value2) {
        this.checkIndex0(index2, 3);
        this.unwrap().setMediumLE(this.idx(index2), value2);
        return this;
    }

    @Override
    protected void _setMediumLE(int index2, int value2) {
        this.unwrap().setMediumLE(this.idx(index2), value2);
    }

    @Override
    public ByteBuf setInt(int index2, int value2) {
        this.checkIndex0(index2, 4);
        this.unwrap().setInt(this.idx(index2), value2);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value2) {
        this.unwrap().setInt(this.idx(index2), value2);
    }

    @Override
    public ByteBuf setIntLE(int index2, int value2) {
        this.checkIndex0(index2, 4);
        this.unwrap().setIntLE(this.idx(index2), value2);
        return this;
    }

    @Override
    protected void _setIntLE(int index2, int value2) {
        this.unwrap().setIntLE(this.idx(index2), value2);
    }

    @Override
    public ByteBuf setLong(int index2, long value2) {
        this.checkIndex0(index2, 8);
        this.unwrap().setLong(this.idx(index2), value2);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value2) {
        this.unwrap().setLong(this.idx(index2), value2);
    }

    @Override
    public ByteBuf setLongLE(int index2, long value2) {
        this.checkIndex0(index2, 8);
        this.unwrap().setLongLE(this.idx(index2), value2);
        return this;
    }

    @Override
    protected void _setLongLE(int index2, long value2) {
        this.unwrap().setLongLE(this.idx(index2), value2);
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length2) {
        this.checkIndex0(index2, length2);
        this.unwrap().setBytes(this.idx(index2), src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length2) {
        this.checkIndex0(index2, length2);
        this.unwrap().setBytes(this.idx(index2), src, srcIndex, length2);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.checkIndex0(index2, src.remaining());
        this.unwrap().setBytes(this.idx(index2), src);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length2) throws IOException {
        this.checkIndex0(index2, length2);
        this.unwrap().getBytes(this.idx(index2), out, length2);
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length2) throws IOException {
        this.checkIndex0(index2, length2);
        return this.unwrap().getBytes(this.idx(index2), out, length2);
    }

    @Override
    public int getBytes(int index2, FileChannel out, long position, int length2) throws IOException {
        this.checkIndex0(index2, length2);
        return this.unwrap().getBytes(this.idx(index2), out, position, length2);
    }

    @Override
    public int setBytes(int index2, InputStream in, int length2) throws IOException {
        this.checkIndex0(index2, length2);
        return this.unwrap().setBytes(this.idx(index2), in, length2);
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length2) throws IOException {
        this.checkIndex0(index2, length2);
        return this.unwrap().setBytes(this.idx(index2), in, length2);
    }

    @Override
    public int setBytes(int index2, FileChannel in, long position, int length2) throws IOException {
        this.checkIndex0(index2, length2);
        return this.unwrap().setBytes(this.idx(index2), in, position, length2);
    }

    @Override
    public int nioBufferCount() {
        return this.unwrap().nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer(int index2, int length2) {
        this.checkIndex0(index2, length2);
        return this.unwrap().nioBuffer(this.idx(index2), length2);
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length2) {
        this.checkIndex0(index2, length2);
        return this.unwrap().nioBuffers(this.idx(index2), length2);
    }

    @Override
    public int forEachByte(int index2, int length2, ByteProcessor processor) {
        this.checkIndex0(index2, length2);
        int ret = this.unwrap().forEachByte(this.idx(index2), length2, processor);
        if (ret >= this.adjustment) {
            return ret - this.adjustment;
        }
        return -1;
    }

    @Override
    public int forEachByteDesc(int index2, int length2, ByteProcessor processor) {
        this.checkIndex0(index2, length2);
        int ret = this.unwrap().forEachByteDesc(this.idx(index2), length2, processor);
        if (ret >= this.adjustment) {
            return ret - this.adjustment;
        }
        return -1;
    }

    final int idx(int index2) {
        return index2 + this.adjustment;
    }

    static void checkSliceOutOfBounds(int index2, int length2, ByteBuf buffer) {
        if (MathUtil.isOutOfBounds(index2, length2, buffer.capacity())) {
            throw new IndexOutOfBoundsException(buffer + ".slice(" + index2 + ", " + length2 + ')');
        }
    }
}

