/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.http.multipart;

import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;

final class HttpPostBodyUtil {
    public static final int chunkSize = 8096;
    public static final String DEFAULT_BINARY_CONTENT_TYPE = "application/octet-stream";
    public static final String DEFAULT_TEXT_CONTENT_TYPE = "text/plain";

    private HttpPostBodyUtil() {
    }

    static int findNonWhitespace(String sb, int offset2) {
        int result2;
        for (result2 = offset2; result2 < sb.length() && Character.isWhitespace(sb.charAt(result2)); ++result2) {
        }
        return result2;
    }

    static int findEndOfString(String sb) {
        int result2;
        for (result2 = sb.length(); result2 > 0 && Character.isWhitespace(sb.charAt(result2 - 1)); --result2) {
        }
        return result2;
    }

    static int findLineBreak(ByteBuf buffer, int index2) {
        int toRead = buffer.readableBytes() - (index2 - buffer.readerIndex());
        int posFirstChar = buffer.bytesBefore(index2, toRead, (byte)10);
        if (posFirstChar == -1) {
            return -1;
        }
        if (posFirstChar > 0 && buffer.getByte(index2 + posFirstChar - 1) == 13) {
            --posFirstChar;
        }
        return posFirstChar;
    }

    static int findLastLineBreak(ByteBuf buffer, int index2) {
        int next2;
        int candidate = HttpPostBodyUtil.findLineBreak(buffer, index2);
        int findCRLF = 0;
        if (candidate >= 0) {
            findCRLF = buffer.getByte(index2 + candidate) == 13 ? 2 : 1;
            candidate += findCRLF;
        }
        while (candidate > 0 && (next2 = HttpPostBodyUtil.findLineBreak(buffer, index2 + candidate)) >= 0) {
            findCRLF = buffer.getByte(index2 + (candidate += next2)) == 13 ? 2 : 1;
            candidate += findCRLF;
        }
        return candidate - findCRLF;
    }

    static int findDelimiter(ByteBuf buffer, int index2, byte[] delimiter, boolean precededByLineBreak) {
        int delimiterLength = delimiter.length;
        int readerIndex = buffer.readerIndex();
        int writerIndex = buffer.writerIndex();
        int toRead = writerIndex - index2;
        int newOffset = index2;
        boolean delimiterNotFound = true;
        while (delimiterNotFound && delimiterLength <= toRead) {
            int posDelimiter = buffer.bytesBefore(newOffset, toRead, delimiter[0]);
            if (posDelimiter < 0) {
                return -1;
            }
            newOffset += posDelimiter;
            toRead -= posDelimiter;
            delimiterNotFound = false;
            for (int i2 = 0; i2 < delimiterLength; ++i2) {
                if (buffer.getByte(newOffset + i2) == delimiter[i2]) continue;
                ++newOffset;
                --toRead;
                delimiterNotFound = true;
                break;
            }
            if (delimiterNotFound) continue;
            if (precededByLineBreak && newOffset > readerIndex) {
                if (buffer.getByte(newOffset - 1) == 10) {
                    if (--newOffset > readerIndex && buffer.getByte(newOffset - 1) == 13) {
                        --newOffset;
                    }
                } else {
                    ++newOffset;
                    --toRead;
                    delimiterNotFound = true;
                    continue;
                }
            }
            return newOffset - readerIndex;
        }
        return -1;
    }

    static class SeekAheadOptimize {
        byte[] bytes;
        int readerIndex;
        int pos;
        int origPos;
        int limit;
        ByteBuf buffer;

        SeekAheadOptimize(ByteBuf buffer) {
            if (!buffer.hasArray()) {
                throw new IllegalArgumentException("buffer hasn't backing byte array");
            }
            this.buffer = buffer;
            this.bytes = buffer.array();
            this.readerIndex = buffer.readerIndex();
            this.origPos = this.pos = buffer.arrayOffset() + this.readerIndex;
            this.limit = buffer.arrayOffset() + buffer.writerIndex();
        }

        void setReadPosition(int minus) {
            this.pos -= minus;
            this.readerIndex = this.getReadPosition(this.pos);
            this.buffer.readerIndex(this.readerIndex);
        }

        int getReadPosition(int index2) {
            return index2 - this.origPos + this.readerIndex;
        }
    }

    public static enum TransferEncodingMechanism {
        BIT7("7bit"),
        BIT8("8bit"),
        BINARY("binary");

        private final String value;

        private TransferEncodingMechanism(String value2) {
            this.value = value2;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

