/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.mqtt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hbase.thirdparty.io.netty.handler.codec.mqtt.MqttQoS;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;

public class MqttSubAckPayload {
    private final List<Integer> reasonCodes;

    public MqttSubAckPayload(int ... reasonCodes) {
        ObjectUtil.checkNotNull(reasonCodes, "reasonCodes");
        ArrayList<Integer> list2 = new ArrayList<Integer>(reasonCodes.length);
        for (int v : reasonCodes) {
            list2.add(v);
        }
        this.reasonCodes = Collections.unmodifiableList(list2);
    }

    public MqttSubAckPayload(Iterable<Integer> reasonCodes) {
        ObjectUtil.checkNotNull(reasonCodes, "reasonCodes");
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        for (Integer v : reasonCodes) {
            if (v == null) break;
            list2.add(v);
        }
        this.reasonCodes = Collections.unmodifiableList(list2);
    }

    public List<Integer> grantedQoSLevels() {
        ArrayList<Integer> qosLevels = new ArrayList<Integer>(this.reasonCodes.size());
        for (int code : this.reasonCodes) {
            if (code > MqttQoS.EXACTLY_ONCE.value()) {
                qosLevels.add(MqttQoS.FAILURE.value());
                continue;
            }
            qosLevels.add(code);
        }
        return qosLevels;
    }

    public List<Integer> reasonCodes() {
        return this.reasonCodes;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '[' + "reasonCodes=" + this.reasonCodes + ']';
    }
}

