/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.resolver.dns;

import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsQuestion;
import org.apache.hbase.thirdparty.io.netty.handler.logging.LogLevel;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.DnsQueryLifecycleObserver;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.LoggingDnsQueryLifecycleObserver;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogLevel;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogger;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLoggerFactory;

public final class LoggingDnsQueryLifeCycleObserverFactory
implements DnsQueryLifecycleObserverFactory {
    private static final InternalLogger DEFAULT_LOGGER = InternalLoggerFactory.getInstance(LoggingDnsQueryLifeCycleObserverFactory.class);
    private final InternalLogger logger;
    private final InternalLogLevel level;

    public LoggingDnsQueryLifeCycleObserverFactory() {
        this(LogLevel.DEBUG);
    }

    public LoggingDnsQueryLifeCycleObserverFactory(LogLevel level2) {
        this.level = LoggingDnsQueryLifeCycleObserverFactory.checkAndConvertLevel(level2);
        this.logger = DEFAULT_LOGGER;
    }

    public LoggingDnsQueryLifeCycleObserverFactory(Class<?> classContext, LogLevel level2) {
        this.level = LoggingDnsQueryLifeCycleObserverFactory.checkAndConvertLevel(level2);
        this.logger = InternalLoggerFactory.getInstance(ObjectUtil.checkNotNull(classContext, "classContext"));
    }

    public LoggingDnsQueryLifeCycleObserverFactory(String name2, LogLevel level2) {
        this.level = LoggingDnsQueryLifeCycleObserverFactory.checkAndConvertLevel(level2);
        this.logger = InternalLoggerFactory.getInstance(ObjectUtil.checkNotNull(name2, "name"));
    }

    private static InternalLogLevel checkAndConvertLevel(LogLevel level2) {
        return ObjectUtil.checkNotNull(level2, "level").toInternalLevel();
    }

    @Override
    public DnsQueryLifecycleObserver newDnsQueryLifecycleObserver(DnsQuestion question) {
        return new LoggingDnsQueryLifecycleObserver(question, this.logger, this.level);
    }
}

