/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.resolver.dns;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsRecord;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.DnsCache;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.DnsCacheEntry;

public final class NoopDnsCache
implements DnsCache {
    public static final NoopDnsCache INSTANCE = new NoopDnsCache();

    private NoopDnsCache() {
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean clear(String hostname) {
        return false;
    }

    @Override
    public List<? extends DnsCacheEntry> get(String hostname, DnsRecord[] additionals) {
        return Collections.emptyList();
    }

    @Override
    public DnsCacheEntry cache(String hostname, DnsRecord[] additional, InetAddress address2, long originalTtl, EventLoop loop2) {
        return new NoopDnsCacheEntry(address2);
    }

    @Override
    public DnsCacheEntry cache(String hostname, DnsRecord[] additional, Throwable cause2, EventLoop loop2) {
        return null;
    }

    public String toString() {
        return NoopDnsCache.class.getSimpleName();
    }

    private static final class NoopDnsCacheEntry
    implements DnsCacheEntry {
        private final InetAddress address;

        NoopDnsCacheEntry(InetAddress address2) {
            this.address = address2;
        }

        @Override
        public InetAddress address() {
            return this.address;
        }

        @Override
        public Throwable cause() {
            return null;
        }

        public String toString() {
            return this.address.toString();
        }
    }
}

