/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.atomic;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueueUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscAtomicArrayQueueL3Pad;

public class MpscAtomicArrayQueue<E>
extends MpscAtomicArrayQueueL3Pad<E> {
    public MpscAtomicArrayQueue(int capacity) {
        super(capacity);
    }

    public boolean offerIfBelowThreshold(E e, int threshold) {
        long pIndex;
        if (null == e) {
            throw new NullPointerException();
        }
        int mask = this.mask;
        long capacity = mask + 1;
        long producerLimit = this.lvProducerLimit();
        do {
            long available;
            long size2;
            if ((size2 = capacity - (available = producerLimit - (pIndex = this.lvProducerIndex()))) < (long)threshold) continue;
            long cIndex = this.lvConsumerIndex();
            size2 = pIndex - cIndex;
            if (size2 >= (long)threshold) {
                return false;
            }
            producerLimit = cIndex + capacity;
            this.soProducerLimit(producerLimit);
        } while (!this.casProducerIndex(pIndex, pIndex + 1L));
        int offset2 = AtomicQueueUtil.calcCircularRefElementOffset(pIndex, mask);
        AtomicQueueUtil.soRefElement(this.buffer, offset2, e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        long pIndex;
        if (null == e) {
            throw new NullPointerException();
        }
        int mask = this.mask;
        long producerLimit = this.lvProducerLimit();
        do {
            if ((pIndex = this.lvProducerIndex()) < producerLimit) continue;
            long cIndex = this.lvConsumerIndex();
            producerLimit = cIndex + (long)mask + 1L;
            if (pIndex >= producerLimit) {
                return false;
            }
            this.soProducerLimit(producerLimit);
        } while (!this.casProducerIndex(pIndex, pIndex + 1L));
        int offset2 = AtomicQueueUtil.calcCircularRefElementOffset(pIndex, mask);
        AtomicQueueUtil.soRefElement(this.buffer, offset2, e);
        return true;
    }

    public final int failFastOffer(E e) {
        long producerLimit;
        if (null == e) {
            throw new NullPointerException();
        }
        int mask = this.mask;
        long capacity = mask + 1;
        long pIndex = this.lvProducerIndex();
        if (pIndex >= (producerLimit = this.lvProducerLimit())) {
            long cIndex = this.lvConsumerIndex();
            producerLimit = cIndex + capacity;
            if (pIndex >= producerLimit) {
                return 1;
            }
            this.soProducerLimit(producerLimit);
        }
        if (!this.casProducerIndex(pIndex, pIndex + 1L)) {
            return -1;
        }
        int offset2 = AtomicQueueUtil.calcCircularRefElementOffset(pIndex, mask);
        AtomicQueueUtil.soRefElement(this.buffer, offset2, e);
        return 0;
    }

    @Override
    public E poll() {
        AtomicReferenceArray buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        int offset2 = AtomicQueueUtil.calcCircularRefElementOffset(cIndex, this.mask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset2);
        if (null == e) {
            if (cIndex != this.lvProducerIndex()) {
                while ((e = AtomicQueueUtil.lvRefElement(buffer, offset2)) == null) {
                }
            } else {
                return null;
            }
        }
        AtomicQueueUtil.spRefElement(buffer, offset2, null);
        this.soConsumerIndex(cIndex + 1L);
        return e;
    }

    @Override
    public E peek() {
        AtomicReferenceArray buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        int offset2 = AtomicQueueUtil.calcCircularRefElementOffset(cIndex, this.mask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset2);
        if (null == e) {
            if (cIndex != this.lvProducerIndex()) {
                while ((e = AtomicQueueUtil.lvRefElement(buffer, offset2)) == null) {
                }
            } else {
                return null;
            }
        }
        return e;
    }

    @Override
    public boolean relaxedOffer(E e) {
        return this.offer(e);
    }

    @Override
    public E relaxedPoll() {
        AtomicReferenceArray buffer = this.buffer;
        long cIndex = this.lpConsumerIndex();
        int offset2 = AtomicQueueUtil.calcCircularRefElementOffset(cIndex, this.mask);
        Object e = AtomicQueueUtil.lvRefElement(buffer, offset2);
        if (null == e) {
            return null;
        }
        AtomicQueueUtil.spRefElement(buffer, offset2, null);
        this.soConsumerIndex(cIndex + 1L);
        return e;
    }

    @Override
    public E relaxedPeek() {
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long cIndex = this.lpConsumerIndex();
        return AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(cIndex, mask));
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit2) {
        if (null == c) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit2 < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit2);
        }
        if (limit2 == 0) {
            return 0;
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long cIndex = this.lpConsumerIndex();
        for (int i2 = 0; i2 < limit2; ++i2) {
            long index2 = cIndex + (long)i2;
            int offset2 = AtomicQueueUtil.calcCircularRefElementOffset(index2, mask);
            Object e = AtomicQueueUtil.lvRefElement(buffer, offset2);
            if (null == e) {
                return i2;
            }
            AtomicQueueUtil.spRefElement(buffer, offset2, null);
            this.soConsumerIndex(index2 + 1L);
            c.accept(e);
        }
        return limit2;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2, int limit2) {
        long available;
        long pIndex;
        if (null == s2) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit2 < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit2);
        }
        if (limit2 == 0) {
            return 0;
        }
        int mask = this.mask;
        long capacity = mask + 1;
        long producerLimit = this.lvProducerLimit();
        int actualLimit = 0;
        do {
            if ((available = producerLimit - (pIndex = this.lvProducerIndex())) > 0L) continue;
            long cIndex = this.lvConsumerIndex();
            producerLimit = cIndex + capacity;
            available = producerLimit - pIndex;
            if (available <= 0L) {
                return 0;
            }
            this.soProducerLimit(producerLimit);
        } while (!this.casProducerIndex(pIndex, pIndex + (long)(actualLimit = Math.min((int)available, limit2))));
        AtomicReferenceArray buffer = this.buffer;
        for (int i2 = 0; i2 < actualLimit; ++i2) {
            int offset2 = AtomicQueueUtil.calcCircularRefElementOffset(pIndex + (long)i2, mask);
            AtomicQueueUtil.soRefElement(buffer, offset2, s2.get());
        }
        return actualLimit;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s2) {
        return MessagePassingQueueUtil.fillBounded(this, s2);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit2) {
        MessagePassingQueueUtil.drain(this, c, w, exit2);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s2, MessagePassingQueue.WaitStrategy wait3, MessagePassingQueue.ExitCondition exit2) {
        MessagePassingQueueUtil.fill(this, s2, wait3, exit2);
    }

    @Deprecated
    public int weakOffer(E e) {
        return this.failFastOffer(e);
    }
}

