/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonParseException;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonParser;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonToken;
import org.apache.htrace.shaded.fasterxml.jackson.core.util.JsonParserDelegate;

public class JsonParserSequence
extends JsonParserDelegate {
    protected final JsonParser[] _parsers;
    protected int _nextParser;

    protected JsonParserSequence(JsonParser[] parsers) {
        super(parsers[0]);
        this._parsers = parsers;
        this._nextParser = 1;
    }

    public static JsonParserSequence createFlattened(JsonParser first2, JsonParser second) {
        if (!(first2 instanceof JsonParserSequence) && !(second instanceof JsonParserSequence)) {
            return new JsonParserSequence(new JsonParser[]{first2, second});
        }
        ArrayList<JsonParser> p2 = new ArrayList<JsonParser>();
        if (first2 instanceof JsonParserSequence) {
            ((JsonParserSequence)first2).addFlattenedActiveParsers(p2);
        } else {
            p2.add(first2);
        }
        if (second instanceof JsonParserSequence) {
            ((JsonParserSequence)second).addFlattenedActiveParsers(p2);
        } else {
            p2.add(second);
        }
        return new JsonParserSequence(p2.toArray(new JsonParser[p2.size()]));
    }

    protected void addFlattenedActiveParsers(List<JsonParser> result2) {
        int len = this._parsers.length;
        for (int i2 = this._nextParser - 1; i2 < len; ++i2) {
            JsonParser p2 = this._parsers[i2];
            if (p2 instanceof JsonParserSequence) {
                ((JsonParserSequence)p2).addFlattenedActiveParsers(result2);
                continue;
            }
            result2.add(p2);
        }
    }

    @Override
    public void close() throws IOException {
        do {
            this.delegate.close();
        } while (this.switchToNext());
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        JsonToken t = this.delegate.nextToken();
        if (t != null) {
            return t;
        }
        while (this.switchToNext()) {
            t = this.delegate.nextToken();
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public int containedParsersCount() {
        return this._parsers.length;
    }

    protected boolean switchToNext() {
        if (this._nextParser >= this._parsers.length) {
            return false;
        }
        this.delegate = this._parsers[this._nextParser++];
        return true;
    }
}

