/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;

public class Loader {
    static final String TSTR = "Caught Exception while in Loader.getResource. This may be innocuous.";
    private static boolean ignoreTCL = false;

    public static URL getResource(String resource2, Class clazz) {
        return Loader.getResource(resource2);
    }

    public static URL getResource(String resource2) {
        try {
            URL url0;
            if (!ignoreTCL && (url0 = Loader.innerGetResource(resource2, Loader.getTCL())) != null) {
                return url0;
            }
            URL url = Loader.innerGetResource(resource2, Loader.class.getClassLoader());
            if (url != null) {
                return url;
            }
        }
        catch (SecurityException t) {
            LogLog.warn(TSTR, t);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        LogLog.debug("Trying to find [" + resource2 + "] using ClassLoader.getSystemResource().");
        return ClassLoader.getSystemResource(resource2);
    }

    private static URL innerGetResource(String resource2, ClassLoader classLoader) {
        if (classLoader != null) {
            LogLog.debug("Trying to find [" + resource2 + "] using " + classLoader + " class loader.");
            return classLoader.getResource(resource2);
        }
        return null;
    }

    @Deprecated
    public static boolean isJava1() {
        return false;
    }

    private static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        Method method2 = null;
        try {
            method2 = Thread.class.getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return (ClassLoader)method2.invoke((Object)Thread.currentThread(), null);
    }

    public static Class loadClass(String clazz) throws ClassNotFoundException {
        return Class.forName(clazz);
    }

    static {
        String ignoreTCLProp = OptionConverter.getSystemProperty("log4j.ignoreTCL", null);
        if (ignoreTCLProp != null) {
            ignoreTCL = OptionConverter.toBoolean(ignoreTCLProp, true);
        }
    }
}

