/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import javax.naming.Context;
import javax.naming.NamingException;

public class JNDIUtil {
    public static final String JNDI_JAVA_NAMESPACE = "java:";
    static final String RESTRICTION_MSG = "JNDI name must start with java: but was ";

    public static Object lookupObject(Context ctx, String name2) throws NamingException {
        if (ctx == null) {
            return null;
        }
        if (JNDIUtil.isNullOrEmpty(name2)) {
            return null;
        }
        JNDIUtil.jndiNameSecurityCheck(name2);
        Object lookup = ctx.lookup(name2);
        return lookup;
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static void jndiNameSecurityCheck(String name2) throws NamingException {
        if (!name2.startsWith(JNDI_JAVA_NAMESPACE)) {
            throw new NamingException(RESTRICTION_MSG + name2);
        }
    }
}

