/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.cli.CliCommand;
import org.apache.zookeeper.cli.CliException;
import org.apache.zookeeper.cli.CliParseException;
import org.apache.zookeeper.cli.CliWrapperException;
import org.apache.zookeeper.cli.MalformedPathException;

public class DeleteAllCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public DeleteAllCommand() {
        this("deleteall");
    }

    public DeleteAllCommand(String cmdStr) {
        super(cmdStr, "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        PosixParser parser = new PosixParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        this.printDeprecatedWarning();
        String path2 = this.args[1];
        try {
            ZKUtil.deleteRecursive(this.zk, path2);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    private void printDeprecatedWarning() {
        if ("rmr".equals(this.args[0])) {
            this.err.println("The command 'rmr' has been deprecated. Please use 'deleteall' instead.");
        }
    }
}

