/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyMatchData;
import org.jruby.RubyRegexp;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NthRefNode
extends Node {
    private final int matchNumber;
    private final ByteList nameByteList;

    public NthRefNode(ISourcePosition position, int matchNumber) {
        super(position);
        this.matchNumber = matchNumber;
        this.nameByteList = ByteList.create("$" + matchNumber);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.NTHREFNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitNthRefNode(this);
    }

    public int getMatchNumber() {
        return this.matchNumber;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return RubyRegexp.nth_match(this.matchNumber, context.getCurrentScope().getBackRef(runtime2));
    }

    @Override
    public ByteList definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject backref = context.getCurrentScope().getBackRef(runtime2);
        if (backref instanceof RubyMatchData && !((RubyMatchData)backref).group(this.matchNumber).isNil()) {
            if (!context.getRuntime().is1_9()) {
                return this.nameByteList;
            }
            return GLOBAL_VARIABLE_BYTELIST;
        }
        return null;
    }
}

