/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import org.jruby.RubyArray;
import org.jruby.cext.Cleaner;
import org.jruby.cext.Native;

public final class RArray
extends Cleaner {
    private final long address;

    private RArray(RubyArray ary, long address2) {
        super(ary);
        this.address = address2;
    }

    static RArray newRArray(RubyArray ary, long address2) {
        RArray rarray = new RArray(ary, address2);
        Cleaner.register(rarray);
        return rarray;
    }

    static RArray valueOf(RubyArray ary) {
        RArray rarray = ary.getRArray();
        if (rarray != null) {
            return rarray;
        }
        rarray = RArray.newRArray(ary, Native.newRArray());
        ary.setRArray(rarray);
        return rarray;
    }

    final long address() {
        return this.address;
    }

    void dispose() {
        Native.freeRArray(this.address);
    }
}

