/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Member;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyString;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;

public class RaiseException
extends JumpException {
    public static final boolean DEBUG = false;
    private static final long serialVersionUID = -7612079169559973951L;
    private RubyException exception;
    private String providedMessage;
    private boolean nativeException;
    private StackTraceElement[] cachedTrace;

    public RaiseException(RubyException actException) {
        this(actException, false);
    }

    public RaiseException(RubyException exception2, IRubyObject backtrace2) {
        super(exception2.message.toString());
        this.setException(exception2, false);
        this.preRaise(exception2.getRuntime().getCurrentContext(), backtrace2);
    }

    public RaiseException(Ruby runtime2, RubyClass excptnClass, String msg, boolean nativeException) {
        super(msg);
        if (msg == null) {
            msg = "No message available";
        }
        this.providedMessage = "(" + excptnClass.getName() + ") " + msg;
        this.nativeException = nativeException;
        this.setException((RubyException)RuntimeHelpers.invoke(runtime2.getCurrentContext(), (IRubyObject)excptnClass, "new", (IRubyObject)RubyString.newUnicodeString(excptnClass.getRuntime(), msg)), nativeException);
        this.preRaise(runtime2.getCurrentContext());
    }

    public RaiseException(Ruby runtime2, RubyClass excptnClass, String msg, IRubyObject backtrace2, boolean nativeException) {
        super(msg);
        if (msg == null) {
            msg = "No message available";
        }
        this.providedMessage = "(" + excptnClass.getName() + ") " + msg;
        this.nativeException = nativeException;
        this.setException((RubyException)RuntimeHelpers.invoke(runtime2.getCurrentContext(), (IRubyObject)excptnClass, "new", (IRubyObject)RubyString.newUnicodeString(excptnClass.getRuntime(), msg)), nativeException);
        this.preRaise(runtime2.getCurrentContext(), backtrace2);
    }

    public RaiseException(RubyException exception2, boolean isNativeException) {
        super(exception2.message.toString());
        this.nativeException = isNativeException;
        this.setException(exception2, isNativeException);
        this.preRaise(exception2.getRuntime().getCurrentContext());
    }

    public RaiseException(Throwable cause2, NativeException nativeException) {
        super(RaiseException.buildMessage(cause2), cause2);
        this.providedMessage = RaiseException.buildMessage(cause2);
        this.setException(nativeException, true);
        this.preRaise(nativeException.getRuntime().getCurrentContext());
    }

    public static RaiseException createNativeRaiseException(Ruby runtime2, Throwable cause2) {
        return RaiseException.createNativeRaiseException(runtime2, cause2, null);
    }

    public static RaiseException createNativeRaiseException(Ruby runtime2, Throwable cause2, Member target) {
        NativeException nativeException = new NativeException(runtime2, runtime2.getClass("NativeException"), cause2);
        if (!runtime2.getDebug().isTrue()) {
            nativeException.trimStackTrace(target);
        }
        return new RaiseException(cause2, nativeException);
    }

    private static String buildMessage(Throwable exception2) {
        StringBuilder sb = new StringBuilder();
        StringWriter stackTrace = new StringWriter();
        exception2.printStackTrace(new PrintWriter(stackTrace));
        sb.append("Native Exception: '").append(exception2.getClass()).append("'; ");
        sb.append("Message: ").append(exception2.getMessage()).append("; ");
        sb.append("StackTrace: ").append(stackTrace.getBuffer().toString());
        return sb.toString();
    }

    public String getMessage() {
        if (this.providedMessage == null) {
            this.providedMessage = "(" + this.exception.getMetaClass().getBaseName() + ") " + this.exception.message(this.exception.getRuntime().getCurrentContext()).asJavaString();
        }
        return this.providedMessage;
    }

    public RubyException getException() {
        return this.exception;
    }

    private void preRaise(ThreadContext context) {
        this.preRaise(context, null);
    }

    private void preRaise(ThreadContext context, IRubyObject backtrace2) {
        context.runtime.incrementExceptionCount();
        this.doSetLastError(context);
        this.doCallEventHook(context);
        if (backtrace2 == null) {
            context.runtime.incrementBacktraceCount();
            this.exception.prepareBacktrace(context, this.nativeException);
            if (RubyInstanceConfig.LOG_BACKTRACES) {
                TraceType.dumpBacktrace(this.exception);
            }
        } else {
            this.exception.forceBacktrace(backtrace2);
        }
        if (RubyInstanceConfig.LOG_EXCEPTIONS) {
            TraceType.dumpException(this.exception);
        }
    }

    private void doCallEventHook(ThreadContext context) {
        if (context.runtime.hasEventHooks()) {
            context.runtime.callEventHooks(context, RubyEvent.RAISE, context.getFile(), context.getLine(), context.getFrameName(), context.getFrameKlazz());
        }
    }

    private void doSetLastError(ThreadContext context) {
        if (!context.isWithinDefined()) {
            context.runtime.getGlobalVariables().set("$!", this.exception);
        }
    }

    public StackTraceElement[] getStackTrace() {
        if (this.cachedTrace == null) {
            if (this.exception instanceof NativeException) {
                this.cachedTrace = ((NativeException)this.exception).getCause().getStackTrace();
                this.setStackTrace(this.cachedTrace);
            } else {
                this.cachedTrace = this.javaTraceFromRubyTrace(this.exception.getBacktraceElements());
                this.setStackTrace(this.cachedTrace);
            }
        }
        return this.cachedTrace;
    }

    protected void setException(RubyException newException, boolean nativeException) {
        this.exception = newException;
    }

    private StackTraceElement[] javaTraceFromRubyTrace(RubyStackTraceElement[] trace) {
        StackTraceElement[] newTrace = new StackTraceElement[trace.length];
        for (int i2 = 0; i2 < newTrace.length; ++i2) {
            newTrace[i2] = trace[i2].getElement();
        }
        return newTrace;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream ps) {
        this.getStackTrace();
        super.printStackTrace(ps);
    }

    public void printStackTrace(PrintWriter pw) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.printStackTrace(new PrintStream(baos));
        pw.print(baos.toString());
    }
}

