/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.ArrayList;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyContinuation;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.ast.executable.RuntimeCache;
import org.jruby.exceptions.JumpException;
import org.jruby.ext.fiber.Fiber;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceElement;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.profile.IProfileData;
import org.jruby.runtime.profile.ProfileData;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.util.RecursiveComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadContext {
    private static final int INITIAL_SIZE = 10;
    private static final int INITIAL_FRAMES_SIZE = 10;
    private static final int CALL_POLL_COUNT = 4095;
    public final Ruby runtime;
    public final IRubyObject nil;
    public final RuntimeCache runtimeCache;
    private boolean isWithinTrace;
    private boolean isWithinDefined;
    private RubyThread thread;
    private Fiber fiber;
    private RubyModule[] parentStack = new RubyModule[10];
    private int parentIndex = -1;
    private Frame[] frameStack = new Frame[10];
    private int frameIndex = -1;
    private BacktraceElement[] backtrace = new BacktraceElement[10];
    private int backtraceIndex = -1;
    private DynamicScope[] scopeStack = new DynamicScope[10];
    private int scopeIndex = -1;
    private static final RubyContinuation.Continuation[] EMPTY_CATCHTARGET_STACK = new RubyContinuation.Continuation[0];
    private RubyContinuation.Continuation[] catchStack = EMPTY_CATCHTARGET_STACK;
    private int catchIndex = -1;
    private boolean isProfiling = false;
    private IProfileData profileData;
    private int rubyFrameDelta = 0;
    private boolean eventHooksEnabled = true;
    CallType lastCallType;
    Visibility lastVisibility;
    IRubyObject lastExitStatus;
    public int callNumber = 0;
    private int currentMethodSerial = 0;
    private Set<RecursiveComparator.Pair> recursiveSet;

    public static ThreadContext newContext(Ruby runtime2) {
        ThreadContext context = new ThreadContext(runtime2);
        return context;
    }

    private ThreadContext(Ruby runtime2) {
        this.runtime = runtime2;
        this.nil = runtime2.getNil();
        if (runtime2.getInstanceConfig().isProfilingEntireRun()) {
            this.startProfiling();
        }
        this.runtimeCache = runtime2.getRuntimeCache();
        LocalStaticScope topStaticScope = new LocalStaticScope(null);
        this.pushScope(new ManyVarsDynamicScope(topStaticScope, null));
        Frame[] stack = this.frameStack;
        int length2 = stack.length;
        for (int i2 = 0; i2 < length2; ++i2) {
            stack[i2] = new Frame();
        }
        BacktraceElement[] stack2 = this.backtrace;
        int length22 = stack2.length;
        for (int i3 = 0; i3 < length22; ++i3) {
            stack2[i3] = new BacktraceElement();
        }
        ThreadContext.pushBacktrace(this, "", "", "", 0);
        ThreadContext.pushBacktrace(this, "", "", "", 0);
        this.fiber = (Fiber)runtime2.getRootFiber();
    }

    protected void finalize() throws Throwable {
        if (this.thread != null) {
            this.thread.dispose();
        }
    }

    public final Ruby getRuntime() {
        return this.runtime;
    }

    public IRubyObject getErrorInfo() {
        return this.thread.getErrorInfo();
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.thread.setErrorInfo(errorInfo);
        return errorInfo;
    }

    public JumpException.ReturnJump returnJump(IRubyObject value2) {
        return new JumpException.ReturnJump(this.getFrameJumpTarget(), value2);
    }

    public void setLastCallStatus(CallType callType) {
        this.lastCallType = callType;
    }

    public CallType getLastCallType() {
        return this.lastCallType;
    }

    public void setLastVisibility(Visibility visibility) {
        this.lastVisibility = visibility;
    }

    public Visibility getLastVisibility() {
        return this.lastVisibility;
    }

    public void setLastCallStatusAndVisibility(CallType callType, Visibility visibility) {
        this.lastCallType = callType;
        this.lastVisibility = visibility;
    }

    public IRubyObject getLastExitStatus() {
        return this.lastExitStatus;
    }

    public void setLastExitStatus(IRubyObject lastExitStatus) {
        this.lastExitStatus = lastExitStatus;
    }

    public void printScope() {
        System.out.println("SCOPE STACK:");
        for (int i2 = 0; i2 <= this.scopeIndex; ++i2) {
            System.out.println(this.scopeStack[i2]);
        }
    }

    public DynamicScope getCurrentScope() {
        return this.scopeStack[this.scopeIndex];
    }

    public DynamicScope getPreviousScope() {
        return this.scopeStack[this.scopeIndex - 1];
    }

    private void expandFramesIfNecessary() {
        int newSize = this.frameStack.length * 2;
        this.frameStack = this.fillNewFrameStack(new Frame[newSize], newSize);
    }

    private Frame[] fillNewFrameStack(Frame[] newFrameStack, int newSize) {
        System.arraycopy(this.frameStack, 0, newFrameStack, 0, this.frameStack.length);
        for (int i2 = this.frameStack.length; i2 < newSize; ++i2) {
            newFrameStack[i2] = new Frame();
        }
        return newFrameStack;
    }

    private void expandParentsIfNecessary() {
        int newSize = this.parentStack.length * 2;
        RubyModule[] newParentStack = new RubyModule[newSize];
        System.arraycopy(this.parentStack, 0, newParentStack, 0, this.parentStack.length);
        this.parentStack = newParentStack;
    }

    public void pushScope(DynamicScope scope) {
        int index2 = ++this.scopeIndex;
        DynamicScope[] stack = this.scopeStack;
        stack[index2] = scope;
        if (index2 + 1 == stack.length) {
            this.expandScopesIfNecessary();
        }
    }

    public void popScope() {
        this.scopeStack[this.scopeIndex--] = null;
    }

    private void expandScopesIfNecessary() {
        int newSize = this.scopeStack.length * 2;
        DynamicScope[] newScopeStack = new DynamicScope[newSize];
        System.arraycopy(this.scopeStack, 0, newScopeStack, 0, this.scopeStack.length);
        this.scopeStack = newScopeStack;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public void setThread(RubyThread thread) {
        this.thread = thread;
        if (thread != null) {
            thread.setContext(this);
        }
    }

    public Fiber getFiber() {
        return this.fiber;
    }

    public void setFiber(Fiber fiber2) {
        this.fiber = fiber2;
    }

    private void expandCatchIfNecessary() {
        int newSize = this.catchStack.length * 2;
        if (newSize == 0) {
            newSize = 1;
        }
        RubyContinuation.Continuation[] newCatchStack = new RubyContinuation.Continuation[newSize];
        System.arraycopy(this.catchStack, 0, newCatchStack, 0, this.catchStack.length);
        this.catchStack = newCatchStack;
    }

    public void pushCatch(RubyContinuation.Continuation catchTarget) {
        int index2;
        if ((index2 = ++this.catchIndex) == this.catchStack.length) {
            this.expandCatchIfNecessary();
        }
        this.catchStack[index2] = catchTarget;
    }

    public void popCatch() {
        --this.catchIndex;
    }

    public RubyContinuation.Continuation getActiveCatch(Object tag2) {
        for (int i2 = this.catchIndex; i2 >= 0; --i2) {
            RubyContinuation.Continuation c = this.catchStack[i2];
            if (!(this.runtime.is1_9() ? c.tag == tag2 : c.tag.equals(tag2))) continue;
            return c;
        }
        return null;
    }

    private void pushFrameCopy() {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        Frame currentFrame = stack[index2 - 1];
        stack[index2].updateFrame(currentFrame);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private Frame pushFrame(Frame frame) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2] = frame;
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
        return frame;
    }

    private void pushCallFrame(RubyModule clazz, String name2, IRubyObject self, Block block) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrame(clazz, self, name2, block, this.callNumber);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushEvalFrame(IRubyObject self) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrameForEval(self, this.callNumber);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    private void pushFrame(String name2) {
        int index2 = ++this.frameIndex;
        Frame[] stack = this.frameStack;
        stack[index2].updateFrame(name2);
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    public void pushFrame() {
        int index2;
        Frame[] stack = this.frameStack;
        if ((index2 = ++this.frameIndex) + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
    }

    public void popFrame() {
        Frame frame = this.frameStack[this.frameIndex--];
        frame.clear();
    }

    private void popFrameReal(Frame oldFrame) {
        this.frameStack[this.frameIndex--] = oldFrame;
    }

    public Frame getCurrentFrame() {
        return this.frameStack[this.frameIndex];
    }

    public int getRubyFrameDelta() {
        return this.rubyFrameDelta;
    }

    public void setRubyFrameDelta(int newDelta) {
        this.rubyFrameDelta = newDelta;
    }

    public Frame getCurrentRubyFrame() {
        return this.frameStack[this.frameIndex - this.rubyFrameDelta];
    }

    public Frame getNextFrame() {
        int index2 = this.frameIndex;
        Frame[] stack = this.frameStack;
        if (index2 + 1 == stack.length) {
            this.expandFramesIfNecessary();
        }
        return stack[index2 + 1];
    }

    public Frame getPreviousFrame() {
        int index2 = this.frameIndex;
        return index2 < 1 ? null : this.frameStack[index2 - 1];
    }

    public int getFrameCount() {
        return this.frameIndex + 1;
    }

    public Frame[] getFrames(int delta) {
        int top = this.frameIndex + delta;
        Frame[] frames = new Frame[top + 1];
        for (int i2 = 0; i2 <= top; ++i2) {
            frames[i2] = this.frameStack[i2].duplicateForBacktrace();
        }
        return frames;
    }

    private static void expandBacktraceIfNecessary(ThreadContext context) {
        int newSize = context.backtrace.length * 2;
        context.backtrace = ThreadContext.fillNewBacktrace(context, new BacktraceElement[newSize], newSize);
    }

    private static BacktraceElement[] fillNewBacktrace(ThreadContext context, BacktraceElement[] newBacktrace, int newSize) {
        System.arraycopy(context.backtrace, 0, newBacktrace, 0, context.backtrace.length);
        for (int i2 = context.backtrace.length; i2 < newSize; ++i2) {
            newBacktrace[i2] = new BacktraceElement();
        }
        return newBacktrace;
    }

    public static void pushBacktrace(ThreadContext context, String klass, String method2, ISourcePosition position) {
        int index2 = ++context.backtraceIndex;
        BacktraceElement[] stack = context.backtrace;
        BacktraceElement.update(stack[index2], klass, method2, position);
        if (index2 + 1 == stack.length) {
            ThreadContext.expandBacktraceIfNecessary(context);
        }
    }

    public static void pushBacktrace(ThreadContext context, String klass, String method2, String file2, int line) {
        int index2 = ++context.backtraceIndex;
        BacktraceElement[] stack = context.backtrace;
        BacktraceElement.update(stack[index2], klass, method2, file2, line);
        if (index2 + 1 == stack.length) {
            ThreadContext.expandBacktraceIfNecessary(context);
        }
    }

    public static void popBacktrace(ThreadContext context) {
        --context.backtraceIndex;
    }

    public boolean isJumpTargetAlive(int target, int skipFrames) {
        for (int i2 = this.frameIndex - skipFrames; i2 >= 0; --i2) {
            if (this.frameStack[i2].getJumpTarget() != target) continue;
            return true;
        }
        return false;
    }

    public String getFrameName() {
        return this.getCurrentFrame().getName();
    }

    public IRubyObject getFrameSelf() {
        return this.getCurrentFrame().getSelf();
    }

    public int getFrameJumpTarget() {
        return this.getCurrentFrame().getJumpTarget();
    }

    public RubyModule getFrameKlazz() {
        return this.getCurrentFrame().getKlazz();
    }

    public Block getFrameBlock() {
        return this.getCurrentFrame().getBlock();
    }

    public String getFile() {
        return this.backtrace[this.backtraceIndex].filename;
    }

    public int getLine() {
        return this.backtrace[this.backtraceIndex].line;
    }

    public void setFile(String file2) {
        this.backtrace[this.backtraceIndex].filename = file2;
    }

    public void setLine(int line) {
        this.backtrace[this.backtraceIndex].line = line;
    }

    public void setFileAndLine(String file2, int line) {
        this.backtrace[this.backtraceIndex].filename = file2;
        this.backtrace[this.backtraceIndex].line = line;
    }

    public void setFileAndLine(ISourcePosition position) {
        this.backtrace[this.backtraceIndex].filename = position.getFile();
        this.backtrace[this.backtraceIndex].line = position.getStartLine();
    }

    public Visibility getCurrentVisibility() {
        return this.getCurrentFrame().getVisibility();
    }

    public Visibility getPreviousVisibility() {
        return this.getPreviousFrame().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.getCurrentFrame().setVisibility(visibility);
    }

    public void pollThreadEvents() {
        this.thread.pollThreadEvents(this);
    }

    public int getCurrentTarget() {
        return this.callNumber;
    }

    public void callThreadPoll() {
        if ((this.callNumber++ & 0xFFF) == 0) {
            this.pollThreadEvents();
        }
    }

    public static void callThreadPoll(ThreadContext context) {
        if ((context.callNumber++ & 0xFFF) == 0) {
            context.pollThreadEvents();
        }
    }

    public void trace(RubyEvent event, String name2, RubyModule implClass) {
        this.trace(event, name2, implClass, this.backtrace[this.backtraceIndex].filename, this.backtrace[this.backtraceIndex].line);
    }

    public void trace(RubyEvent event, String name2, RubyModule implClass, String file2, int line) {
        this.runtime.callEventHooks(this, event, file2, line, name2, implClass);
    }

    public void pushRubyClass(RubyModule currentModule) {
        int index2 = ++this.parentIndex;
        RubyModule[] stack = this.parentStack;
        stack[index2] = currentModule;
        if (index2 + 1 == stack.length) {
            this.expandParentsIfNecessary();
        }
    }

    public RubyModule popRubyClass() {
        int index2 = this.parentIndex;
        RubyModule[] stack = this.parentStack;
        RubyModule ret = stack[index2];
        stack[index2] = null;
        this.parentIndex = index2 - 1;
        return ret;
    }

    public RubyModule getRubyClass() {
        assert (this.parentIndex != -1) : "Trying to get RubyClass from empty stack";
        RubyModule parentModule = this.parentStack[this.parentIndex];
        return parentModule.getNonIncludedClass();
    }

    public RubyModule getPreviousRubyClass() {
        assert (this.parentIndex != 0) : "Trying to get RubyClass from too-shallow stack";
        RubyModule parentModule = this.parentStack[this.parentIndex - 1];
        return parentModule.getNonIncludedClass();
    }

    public boolean getConstantDefined(String internedName) {
        IRubyObject value2 = this.getConstant(internedName);
        return value2 != null;
    }

    public IRubyObject getConstant(String internedName) {
        return this.getCurrentScope().getStaticScope().getConstant(this.runtime, internedName, this.runtime.getObject());
    }

    public IRubyObject setConstantInCurrent(String internedName, IRubyObject result2) {
        RubyModule module = this.getCurrentScope().getStaticScope().getModule();
        if (module != null) {
            module.fastSetConstant(internedName, result2);
            return result2;
        }
        throw this.runtime.newTypeError("no class/module to define constant");
    }

    public IRubyObject setConstantInModule(String internedName, IRubyObject target, IRubyObject result2) {
        if (!(target instanceof RubyModule)) {
            throw this.runtime.newTypeError(target.toString() + " is not a class/module");
        }
        RubyModule module = (RubyModule)target;
        module.fastSetConstant(internedName, result2);
        return result2;
    }

    public IRubyObject setConstantInObject(String internedName, IRubyObject result2) {
        this.runtime.getObject().fastSetConstant(internedName, result2);
        return result2;
    }

    private static void addBackTraceElement(Ruby runtime2, RubyArray backtrace2, RubyStackTraceElement element) {
        RubyString str = RubyString.newString(runtime2, element.getFileName() + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'");
        backtrace2.append(str);
    }

    public IRubyObject createCallerBacktrace(Ruby runtime2, int level2) {
        runtime2.incrementCallerCount();
        RubyStackTraceElement[] trace = this.gatherCallerBacktrace(level2);
        RubyArray backtrace2 = runtime2.newArray(trace.length - level2);
        for (int i2 = level2; i2 < trace.length; ++i2) {
            ThreadContext.addBackTraceElement(runtime2, backtrace2, trace[i2]);
        }
        if (RubyInstanceConfig.LOG_CALLERS) {
            TraceType.dumpCaller(backtrace2);
        }
        return backtrace2;
    }

    public RubyStackTraceElement[] gatherCallerBacktrace(int level2) {
        Thread nativeThread = this.thread.getNativeThread();
        if (nativeThread == null) {
            return new RubyStackTraceElement[0];
        }
        BacktraceElement[] copy = new BacktraceElement[this.backtraceIndex + 1];
        System.arraycopy(this.backtrace, 0, copy, 0, this.backtraceIndex + 1);
        RubyStackTraceElement[] trace = TraceType.Gather.CALLER.getBacktraceData(this, false).getBacktrace(this.runtime);
        return trace;
    }

    public Frame[] createBacktrace(int level2, boolean nativeException) {
        Frame[] traceFrames;
        int traceSize = this.frameIndex - level2 + 1;
        if (traceSize <= 0) {
            return null;
        }
        if (nativeException) {
            traceFrames = new Frame[traceSize + 1];
            traceFrames[traceSize] = this.frameStack[this.frameIndex];
        } else {
            traceFrames = new Frame[traceSize];
        }
        System.arraycopy(this.frameStack, 0, traceFrames, 0, traceSize);
        return traceFrames;
    }

    public boolean isEventHooksEnabled() {
        return this.eventHooksEnabled;
    }

    public void setEventHooksEnabled(boolean flag) {
        this.eventHooksEnabled = flag;
    }

    public BacktraceElement[] createBacktrace2(int level2, boolean nativeException) {
        BacktraceElement[] newTrace = new BacktraceElement[this.backtraceIndex + 1];
        for (int i2 = 0; i2 <= this.backtraceIndex; ++i2) {
            newTrace[i2] = this.backtrace[i2].clone();
        }
        return newTrace;
    }

    private static String createRubyBacktraceString(StackTraceElement element) {
        return element.getFileName() + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'";
    }

    public static String createRawBacktraceStringFromThrowable(Throwable t) {
        StackTraceElement[] javaStackTrace = t.getStackTrace();
        StringBuffer buffer = new StringBuffer();
        if (javaStackTrace != null && javaStackTrace.length > 0) {
            StackTraceElement element = javaStackTrace[0];
            buffer.append(ThreadContext.createRubyBacktraceString(element)).append(": ").append(t.toString()).append("\n");
            for (int i2 = 1; i2 < javaStackTrace.length; ++i2) {
                element = javaStackTrace[i2];
                buffer.append("\tfrom ").append(ThreadContext.createRubyBacktraceString(element));
                if (i2 + 1 >= javaStackTrace.length) continue;
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public static RubyStackTraceElement[] gatherRawBacktrace(Ruby runtime2, StackTraceElement[] stackTrace) {
        ArrayList<RubyStackTraceElement> trace = new ArrayList<RubyStackTraceElement>(stackTrace.length);
        for (int i2 = 0; i2 < stackTrace.length; ++i2) {
            StackTraceElement element = stackTrace[i2];
            trace.add(new RubyStackTraceElement(element));
        }
        RubyStackTraceElement[] rubyStackTrace = new RubyStackTraceElement[trace.size()];
        return trace.toArray(rubyStackTrace);
    }

    private Frame pushFrameForBlock(Binding binding2) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding2.getFrame());
        f.setVisibility(binding2.getVisibility());
        return lastFrame;
    }

    private Frame pushFrameForEval(Binding binding2) {
        Frame lastFrame = this.getNextFrame();
        Frame f = this.pushFrame(binding2.getFrame());
        f.setVisibility(binding2.getVisibility());
        return lastFrame;
    }

    public void preAdoptThread() {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.getCurrentFrame().setSelf(this.runtime.getTopSelf());
    }

    public void preExtensionLoad(IRubyObject self) {
        this.pushFrame();
        this.pushRubyClass(this.runtime.getObject());
        this.getCurrentFrame().setSelf(self);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
    }

    public void postExtensionLoad() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preCompiledClass(RubyModule type2, StaticScope staticScope) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        staticScope.setModule(type2);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
    }

    public void preCompiledClassDummyScope(RubyModule type2, StaticScope staticScope) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        staticScope.setModule(type2);
        this.pushScope(staticScope.getDummyScope());
    }

    public void postCompiledClass() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preScopeNode(StaticScope staticScope) {
        this.pushScope(DynamicScope.newDynamicScope(staticScope, this.getCurrentScope()));
    }

    public void postScopeNode() {
        this.popScope();
    }

    public void preClassEval(StaticScope staticScope, RubyModule type2) {
        this.pushRubyClass(type2);
        this.pushFrameCopy();
        this.getCurrentFrame().setSelf(type2);
        this.getCurrentFrame().setVisibility(Visibility.PUBLIC);
        this.pushScope(DynamicScope.newDynamicScope(staticScope, null));
    }

    public void postClassEval() {
        this.popScope();
        this.popRubyClass();
        this.popFrame();
    }

    public void preBsfApply(String[] names2) {
        LocalStaticScope staticScope = new LocalStaticScope(null);
        staticScope.setVariables(names2);
        this.pushFrame();
    }

    public void postBsfApply() {
        this.popFrame();
    }

    public void preMethodFrameAndScope(RubyModule clazz, String name2, IRubyObject self, Block block, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushCallFrame(clazz, name2, self, block);
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void preMethodFrameAndDummyScope(RubyModule clazz, String name2, IRubyObject self, Block block, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushCallFrame(clazz, name2, self, block);
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void preMethodNoFrameAndDummyScope(RubyModule clazz, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void postMethodFrameAndScope() {
        this.popRubyClass();
        this.popScope();
        this.popFrame();
    }

    public void preMethodFrameOnly(RubyModule clazz, String name2, IRubyObject self, Block block) {
        this.pushRubyClass(clazz);
        this.pushCallFrame(clazz, name2, self, block);
    }

    public void postMethodFrameOnly() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preMethodScopeOnly(RubyModule clazz, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(DynamicScope.newDynamicScope(staticScope));
        this.pushRubyClass(implementationClass);
    }

    public void postMethodScopeOnly() {
        this.popRubyClass();
        this.popScope();
    }

    public void preMethodBacktraceAndScope(String name2, RubyModule clazz, StaticScope staticScope) {
        this.preMethodScopeOnly(clazz, staticScope);
    }

    public void postMethodBacktraceAndScope() {
        this.postMethodScopeOnly();
    }

    public void preMethodBacktraceOnly(String name2) {
    }

    public void preMethodBacktraceDummyScope(RubyModule clazz, String name2, StaticScope staticScope) {
        RubyModule implementationClass = staticScope.getModule();
        if (implementationClass == null) {
            implementationClass = clazz;
        }
        this.pushScope(staticScope.getDummyScope());
        this.pushRubyClass(implementationClass);
    }

    public void postMethodBacktraceOnly() {
    }

    public void postMethodBacktraceDummyScope() {
        this.popRubyClass();
        this.popScope();
    }

    public void prepareTopLevel(RubyClass objectClass, IRubyObject topSelf) {
        this.pushFrame();
        this.setCurrentVisibility(Visibility.PRIVATE);
        this.pushRubyClass(objectClass);
        Frame frame = this.getCurrentFrame();
        frame.setSelf(topSelf);
        this.getCurrentScope().getStaticScope().setModule(objectClass);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self, String name2) {
        this.pushRubyClass(rubyClass);
        this.pushEvalFrame(self);
    }

    public void preNodeEval(RubyModule rubyClass, IRubyObject self) {
        this.pushRubyClass(rubyClass);
        this.pushEvalFrame(self);
    }

    public void postNodeEval() {
        this.popFrame();
        this.popRubyClass();
    }

    public void preExecuteUnder(RubyModule executeUnderClass, Block block) {
        Frame frame = this.getCurrentFrame();
        this.pushRubyClass(executeUnderClass);
        DynamicScope scope = this.getCurrentScope();
        BlockStaticScope sScope = new BlockStaticScope(scope.getStaticScope());
        sScope.setModule(executeUnderClass);
        this.pushScope(DynamicScope.newDynamicScope(sScope, scope));
        this.pushCallFrame(frame.getKlazz(), frame.getName(), frame.getSelf(), block);
        this.getCurrentFrame().setVisibility(this.getPreviousFrame().getVisibility());
    }

    public void postExecuteUnder() {
        this.popFrame();
        this.popScope();
        this.popRubyClass();
    }

    public void preMproc() {
        this.pushFrame();
    }

    public void postMproc() {
        this.popFrame();
    }

    public void preRunThread(Frame[] currentFrames) {
        for (Frame frame : currentFrames) {
            this.pushFrame(frame);
        }
    }

    public void preTrace() {
        this.setWithinTrace(true);
        this.pushFrame();
    }

    public void postTrace() {
        this.popFrame();
        this.setWithinTrace(false);
    }

    public Frame preForBlock(Binding binding2, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(binding2.getDynamicScope());
        return lastFrame;
    }

    public Frame preYieldSpecificBlock(Binding binding2, StaticScope scope, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(DynamicScope.newDynamicScope(scope, binding2.getDynamicScope()));
        return lastFrame;
    }

    public Frame preYieldLightBlock(Binding binding2, DynamicScope emptyScope, RubyModule klass) {
        Frame lastFrame = this.preYieldNoScope(binding2, klass);
        this.pushScope(emptyScope);
        return lastFrame;
    }

    public Frame preYieldNoScope(Binding binding2, RubyModule klass) {
        this.pushRubyClass(klass != null ? klass : binding2.getKlass());
        return this.pushFrameForBlock(binding2);
    }

    public void preEvalScriptlet(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postEvalScriptlet() {
        this.popScope();
    }

    public Frame preEvalWithBinding(Binding binding2) {
        binding2.getFrame().setIsBindingFrame(true);
        Frame lastFrame = this.pushFrameForEval(binding2);
        this.pushRubyClass(binding2.getKlass());
        return lastFrame;
    }

    public void postEvalWithBinding(Binding binding2, Frame lastFrame) {
        binding2.getFrame().setIsBindingFrame(false);
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYield(Binding binding2, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldLight(Binding binding2, Frame lastFrame) {
        this.popScope();
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void postYieldNoScope(Frame lastFrame) {
        this.popFrameReal(lastFrame);
        this.popRubyClass();
    }

    public void preScopedBody(DynamicScope scope) {
        this.pushScope(scope);
    }

    public void postScopedBody() {
        this.popScope();
    }

    public boolean isWithinTrace() {
        return this.isWithinTrace;
    }

    public void setWithinTrace(boolean isWithinTrace) {
        this.isWithinTrace = isWithinTrace;
    }

    public boolean isWithinDefined() {
        return this.isWithinDefined;
    }

    public void setWithinDefined(boolean isWithinDefined) {
        this.isWithinDefined = isWithinDefined;
    }

    public Binding currentBinding() {
        Frame frame = this.getCurrentFrame();
        return new Binding(frame, this.getRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, frame.getVisibility(), this.getRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self, Visibility visibility) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, visibility, this.getRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self, DynamicScope scope) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, frame.getVisibility(), this.getRubyClass(), scope, this.backtrace[this.backtraceIndex].clone());
    }

    public Binding currentBinding(IRubyObject self, Visibility visibility, DynamicScope scope) {
        Frame frame = this.getCurrentFrame();
        return new Binding(self, frame, visibility, this.getRubyClass(), scope, this.backtrace[this.backtraceIndex].clone());
    }

    public Binding previousBinding() {
        Frame frame = this.getPreviousFrame();
        return new Binding(frame, this.getPreviousRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public Binding previousBinding(IRubyObject self) {
        Frame frame = this.getPreviousFrame();
        return new Binding(self, frame, frame.getVisibility(), this.getPreviousRubyClass(), this.getCurrentScope(), this.backtrace[this.backtraceIndex].clone());
    }

    public IProfileData getProfileData() {
        if (this.profileData == null) {
            this.profileData = new ProfileData(this);
        }
        return this.profileData;
    }

    public int profileEnter(int nextMethod) {
        int previousMethodSerial = this.currentMethodSerial;
        this.currentMethodSerial = nextMethod;
        if (this.isProfiling) {
            this.getProfileData().profileEnter(nextMethod);
        }
        return previousMethodSerial;
    }

    public int profileExit(int nextMethod, long startTime) {
        int previousMethodSerial = this.currentMethodSerial;
        this.currentMethodSerial = nextMethod;
        if (this.isProfiling) {
            this.getProfileData().profileExit(nextMethod, startTime);
        }
        return previousMethodSerial;
    }

    public void startProfiling() {
        this.isProfiling = true;
    }

    public void stopProfiling() {
        this.isProfiling = false;
    }

    public boolean isProfiling() {
        return this.isProfiling;
    }

    public Set<RecursiveComparator.Pair> getRecursiveSet() {
        return this.recursiveSet;
    }

    public void setRecursiveSet(Set<RecursiveComparator.Pair> recursiveSet) {
        this.recursiveSet = recursiveSet;
    }
}

