/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jruby.runtime.load.LoadServiceResourceInputStream;
import org.jruby.util.URLUtil;

public class LoadServiceResource {
    private final URL resource;
    private final File path;
    private final String name;
    private final boolean absolute;

    public LoadServiceResource(URL resource2, String name2) {
        this.resource = resource2;
        this.path = null;
        this.name = name2;
        this.absolute = false;
    }

    public LoadServiceResource(URL resource2, String name2, boolean absolute) {
        this.resource = resource2;
        this.path = null;
        this.name = name2;
        this.absolute = absolute;
    }

    public LoadServiceResource(File path2, String name2) {
        this.resource = null;
        this.path = path2;
        this.name = name2;
        this.absolute = false;
    }

    public LoadServiceResource(File path2, String name2, boolean absolute) {
        this.resource = null;
        this.path = path2;
        this.name = name2;
        this.absolute = absolute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        if (this.resource != null) {
            LoadServiceResourceInputStream loadServiceResourceInputStream;
            InputStream is = this.resource.openStream();
            try {
                loadServiceResourceInputStream = new LoadServiceResourceInputStream(is);
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                is.close();
                throw throwable;
            }
            is.close();
            return loadServiceResourceInputStream;
        }
        byte[] bytes2 = new byte[(int)this.path.length()];
        ByteBuffer buffer = ByteBuffer.wrap(bytes2);
        FileInputStream fis = new FileInputStream(this.path);
        FileChannel fc = fis.getChannel();
        fc.read(buffer);
        fis.close();
        return new LoadServiceResourceInputStream(bytes2);
    }

    public String getName() {
        return this.name;
    }

    public File getPath() {
        return this.path;
    }

    public URL getURL() throws IOException {
        if (this.resource != null) {
            return this.resource;
        }
        return new URL("file", null, this.path.getAbsolutePath());
    }

    public String getAbsolutePath() {
        try {
            return new File(URLUtil.getPath(this.getURL())).getCanonicalPath();
        }
        catch (IOException e) {
            return this.resource.toString();
        }
    }

    public boolean isAbsolute() {
        return this.absolute;
    }
}

