/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.primitive.impl.ClasspathScanningPrimitiveTypeRegistry;
import io.atomix.primitive.partition.ManagedMemberGroupService;
import io.atomix.primitive.partition.MemberGroupProvider;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.impl.DefaultMemberGroupService;
import io.atomix.protocols.backup.impl.PrimaryBackupServerContext;
import io.atomix.protocols.backup.protocol.PrimaryBackupServerProtocol;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.ThreadModel;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

public class PrimaryBackupServer
implements Managed<PrimaryBackupServer> {
    private final PrimaryBackupServerContext context;

    public static Builder builder() {
        return new Builder();
    }

    private PrimaryBackupServer(PrimaryBackupServerContext context) {
        this.context = (PrimaryBackupServerContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
    }

    public Role getRole() {
        return this.context.getRole();
    }

    public CompletableFuture<PrimaryBackupServer> start() {
        return this.context.start().thenApply(v -> this);
    }

    public boolean isRunning() {
        return this.context.isRunning();
    }

    public CompletableFuture<Void> stop() {
        return this.context.stop();
    }

    public static class Builder
    implements io.atomix.utils.Builder<PrimaryBackupServer> {
        protected String serverName = "atomix";
        protected ClusterMembershipService membershipService;
        protected PrimaryBackupServerProtocol protocol;
        protected PrimaryElection primaryElection;
        protected PrimitiveTypeRegistry primitiveTypes;
        protected MemberGroupProvider memberGroupProvider;
        protected ThreadModel threadModel = ThreadModel.SHARED_THREAD_POOL;
        protected int threadPoolSize = Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 16), 4);
        protected ThreadContextFactory threadContextFactory;

        public Builder withServerName(String serverName) {
            this.serverName = (String)Preconditions.checkNotNull((Object)serverName, (Object)"server cannot be null");
            return this;
        }

        public Builder withMembershipService(ClusterMembershipService membershipService) {
            this.membershipService = (ClusterMembershipService)Preconditions.checkNotNull((Object)membershipService, (Object)"membershipService cannot be null");
            return this;
        }

        public Builder withProtocol(PrimaryBackupServerProtocol protocol) {
            this.protocol = (PrimaryBackupServerProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withPrimaryElection(PrimaryElection primaryElection) {
            this.primaryElection = (PrimaryElection)Preconditions.checkNotNull((Object)primaryElection, (Object)"primaryElection cannot be null");
            return this;
        }

        public Builder withPrimitiveTypes(PrimitiveTypeRegistry primitiveTypes) {
            this.primitiveTypes = (PrimitiveTypeRegistry)Preconditions.checkNotNull((Object)primitiveTypes, (Object)"primitiveTypes cannot be null");
            return this;
        }

        public Builder withMemberGroupProvider(MemberGroupProvider memberGroupProvider) {
            this.memberGroupProvider = (MemberGroupProvider)Preconditions.checkNotNull((Object)memberGroupProvider);
            return this;
        }

        public Builder withThreadModel(ThreadModel threadModel) {
            this.threadModel = (ThreadModel)Preconditions.checkNotNull((Object)threadModel, (Object)"threadModel cannot be null");
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize must be positive");
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public Builder withThreadContextFactory(ThreadContextFactory threadContextFactory) {
            this.threadContextFactory = (ThreadContextFactory)Preconditions.checkNotNull((Object)threadContextFactory, (Object)"threadContextFactory cannot be null");
            return this;
        }

        public PrimaryBackupServer build() {
            boolean closeOnStop;
            ThreadContextFactory threadContextFactory;
            ContextualLogger log = ContextualLoggerFactory.getLogger(PrimaryBackupServer.class, (LoggerContext)LoggerContext.builder(PrimaryBackupServer.class).addValue((Object)this.serverName).build());
            if (this.threadContextFactory == null) {
                threadContextFactory = this.threadModel.factory("backup-server-" + this.serverName + "-%d", this.threadPoolSize, (Logger)log);
                closeOnStop = true;
            } else {
                threadContextFactory = this.threadContextFactory;
                closeOnStop = false;
            }
            return new PrimaryBackupServer(new PrimaryBackupServerContext(this.serverName, this.membershipService, (ManagedMemberGroupService)new DefaultMemberGroupService(this.membershipService, this.memberGroupProvider), this.protocol, (PrimitiveTypeRegistry)(this.primitiveTypes != null ? this.primitiveTypes : new ClasspathScanningPrimitiveTypeRegistry(Thread.currentThread().getContextClassLoader())), this.primaryElection, threadContextFactory, closeOnStop));
        }
    }

    public static enum Role {
        PRIMARY,
        BACKUP,
        NONE;

    }
}

