/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.partition.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.backup.partition.impl.PrimaryBackupMessageContext;
import io.atomix.protocols.backup.protocol.BackupRequest;
import io.atomix.protocols.backup.protocol.BackupResponse;
import io.atomix.protocols.backup.protocol.CloseRequest;
import io.atomix.protocols.backup.protocol.CloseResponse;
import io.atomix.protocols.backup.protocol.ExecuteRequest;
import io.atomix.protocols.backup.protocol.ExecuteResponse;
import io.atomix.protocols.backup.protocol.MetadataRequest;
import io.atomix.protocols.backup.protocol.MetadataResponse;
import io.atomix.protocols.backup.protocol.PrimaryBackupServerProtocol;
import io.atomix.protocols.backup.protocol.RestoreRequest;
import io.atomix.protocols.backup.protocol.RestoreResponse;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class PrimaryBackupServerCommunicator
implements PrimaryBackupServerProtocol {
    private final PrimaryBackupMessageContext context;
    private final Serializer serializer;
    private final ClusterCommunicationService clusterCommunicator;

    public PrimaryBackupServerCommunicator(String prefix, Serializer serializer, ClusterCommunicationService clusterCommunicator) {
        this.context = new PrimaryBackupMessageContext(prefix);
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.clusterCommunicator = (ClusterCommunicationService)Preconditions.checkNotNull((Object)clusterCommunicator, (Object)"clusterCommunicator cannot be null");
    }

    private <T, U> CompletableFuture<U> sendAndReceive(String subject, T request, MemberId memberId) {
        return this.clusterCommunicator.send(subject, request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), MemberId.from((String)((String)((Object)memberId.id()))));
    }

    @Override
    public CompletableFuture<BackupResponse> backup(MemberId memberId, BackupRequest request) {
        return this.sendAndReceive(this.context.backupSubject, request, memberId);
    }

    @Override
    public CompletableFuture<RestoreResponse> restore(MemberId memberId, RestoreRequest request) {
        return this.sendAndReceive(this.context.restoreSubject, request, memberId);
    }

    @Override
    public void event(MemberId memberId, SessionId session, PrimitiveEvent event) {
        this.clusterCommunicator.unicast(this.context.eventSubject((Long)session.id()), (Object)event, arg_0 -> ((Serializer)this.serializer).encode(arg_0), memberId);
    }

    @Override
    public void registerExecuteHandler(Function<ExecuteRequest, CompletableFuture<ExecuteResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.executeSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterExecuteHandler() {
        this.clusterCommunicator.unsubscribe(this.context.executeSubject);
    }

    @Override
    public void registerBackupHandler(Function<BackupRequest, CompletableFuture<BackupResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.backupSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterBackupHandler() {
        this.clusterCommunicator.unsubscribe(this.context.backupSubject);
    }

    @Override
    public void registerRestoreHandler(Function<RestoreRequest, CompletableFuture<RestoreResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.restoreSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterRestoreHandler() {
        this.clusterCommunicator.unsubscribe(this.context.restoreSubject);
    }

    @Override
    public void registerCloseHandler(Function<CloseRequest, CompletableFuture<CloseResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.closeSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterCloseHandler() {
        this.clusterCommunicator.unsubscribe(this.context.closeSubject);
    }

    @Override
    public void registerMetadataHandler(Function<MetadataRequest, CompletableFuture<MetadataResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.metadataSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterMetadataHandler() {
        this.clusterCommunicator.unsubscribe(this.context.metadataSubject);
    }
}

