/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.parser.RequestMarshallers;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.internal.OSSOperation;
import com.aliyun.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.OptionsRequest;
import com.aliyun.oss.model.SetBucketCORSRequest;
import java.util.LinkedHashMap;
import java.util.List;

public class CORSOperation
extends OSSOperation {
    private static final String SUBRESOURCE_CORS = "cors";

    public CORSOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public void setBucketCORS(SetBucketCORSRequest setBucketCORSRequest) {
        CORSOperation.checkSetBucketCORSRequestValidity(setBucketCORSRequest);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put(SUBRESOURCE_CORS, null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(setBucketCORSRequest.getBucketName()).setParameters(parameters).setInputStreamWithLength(RequestMarshallers.setBucketCORSRequestMarshaller.marshall(setBucketCORSRequest)).setOriginalRequest(setBucketCORSRequest).build();
        this.doOperation(request, emptyResponseParser, setBucketCORSRequest.getBucketName(), null);
    }

    public List<SetBucketCORSRequest.CORSRule> getBucketCORSRules(GenericRequest genericRequest) {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put(SUBRESOURCE_CORS, null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(parameters).setBucket(bucketName).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketCorsResponseParser, bucketName, null, true);
    }

    public void deleteBucketCORS(GenericRequest genericRequest) {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put(SUBRESOURCE_CORS, null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setParameters(parameters).setBucket(bucketName).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public ResponseMessage optionsObject(OptionsRequest optionsRequest) {
        CodingUtils.assertParameterNotNull(optionsRequest, "optionsRequest");
        String bucketName = optionsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.OPTIONS).setBucket(bucketName).setKey(optionsRequest.getObjectName()).addHeader("origin", optionsRequest.getOrigin()).addHeader("Access-Control-Request-Method", optionsRequest.getRequestMethod().name()).addHeader("Access-Control-Request-Headers", optionsRequest.getRequestHeaders()).setOriginalRequest(optionsRequest).build();
        return this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    private static void checkSetBucketCORSRequestValidity(SetBucketCORSRequest setBucketCORSRequest) {
        CodingUtils.assertParameterNotNull(setBucketCORSRequest, "setBucketCORSRequest");
        String bucketName = setBucketCORSRequest.getBucketName();
        CodingUtils.assertStringNotNullOrEmpty(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        List<SetBucketCORSRequest.CORSRule> corsRules = setBucketCORSRequest.getCorsRules();
        CodingUtils.assertListNotNullOrEmpty(corsRules, "corsRules");
        for (SetBucketCORSRequest.CORSRule rule : setBucketCORSRequest.getCorsRules()) {
            CodingUtils.assertListNotNullOrEmpty(rule.getAllowedOrigins(), "allowedOrigin");
            CodingUtils.assertListNotNullOrEmpty(rule.getAllowedMethods(), "allowedMethod");
        }
    }
}

