/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.library;

import com.thoughtworks.qdox.builder.ModelBuilderFactory;
import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.library.ClassLoaderLibrary;
import com.thoughtworks.qdox.library.ClassNameLibrary;
import com.thoughtworks.qdox.library.ErrorHandler;
import com.thoughtworks.qdox.library.SourceFolderLibrary;
import com.thoughtworks.qdox.library.SourceLibrary;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.writer.ModelWriterFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

public class SortedClassLibraryBuilder
implements ClassLibraryBuilder {
    private final ClassNameLibrary classNameLibrary = new ClassNameLibrary();
    private final ClassLoaderLibrary classLoaderLibrary = new ClassLoaderLibrary(this.classNameLibrary);
    private final SourceFolderLibrary sourceFolderLibrary = new SourceFolderLibrary(this.classLoaderLibrary);
    private final SourceLibrary sourceLibrary = new SourceLibrary(this.sourceFolderLibrary);

    public ClassLibraryBuilder appendClassLoader(ClassLoader classLoader) {
        this.classLoaderLibrary.addClassLoader(classLoader);
        return this;
    }

    public ClassLibraryBuilder appendDefaultClassLoaders() {
        this.classLoaderLibrary.addDefaultLoader();
        return this;
    }

    public ClassLibraryBuilder appendSourceFolder(File sourceFolder) {
        this.sourceFolderLibrary.addSourceFolder(sourceFolder);
        return this;
    }

    public ClassLibraryBuilder appendSource(InputStream stream) throws IOException {
        this.sourceLibrary.addSource(stream);
        return this;
    }

    public ClassLibraryBuilder appendSource(Reader reader) {
        this.sourceLibrary.addSource(reader);
        return this;
    }

    public ClassLibraryBuilder appendSource(URL url) throws IOException {
        this.sourceLibrary.addSource(url);
        return this;
    }

    public ClassLibraryBuilder appendSource(File file) throws IOException {
        this.sourceLibrary.addSource(file);
        return this;
    }

    public ClassLibraryBuilder setDebugLexer(boolean debugLexer) {
        this.classLoaderLibrary.setDebugLexer(debugLexer);
        this.sourceFolderLibrary.setDebugLexer(debugLexer);
        this.sourceLibrary.setDebugLexer(debugLexer);
        return this;
    }

    public ClassLibraryBuilder setDebugParser(boolean debugParser) {
        this.classLoaderLibrary.setDebugParser(debugParser);
        this.sourceFolderLibrary.setDebugParser(debugParser);
        this.sourceLibrary.setDebugParser(debugParser);
        return this;
    }

    public ClassLibraryBuilder setEncoding(String encoding) {
        this.sourceFolderLibrary.setEncoding(encoding);
        this.sourceLibrary.setEncoding(encoding);
        return this;
    }

    public ClassLibraryBuilder setErrorHander(ErrorHandler errorHandler) {
        this.classLoaderLibrary.setErrorHandler(errorHandler);
        this.sourceFolderLibrary.setErrorHandler(errorHandler);
        this.sourceLibrary.setErrorHandler(errorHandler);
        return this;
    }

    public ClassLibraryBuilder setModelBuilderFactory(ModelBuilderFactory factory) {
        this.classNameLibrary.setModelBuilderFactory(factory);
        this.classLoaderLibrary.setModelBuilderFactory(factory);
        this.sourceFolderLibrary.setModelBuilderFactory(factory);
        this.sourceLibrary.setModelBuilderFactory(factory);
        return this;
    }

    public ClassLibraryBuilder setModelWriterFactory(ModelWriterFactory modelWriterFactory) {
        this.classNameLibrary.setModelWriterFactory(modelWriterFactory);
        this.classLoaderLibrary.setModelWriterFactory(modelWriterFactory);
        this.sourceFolderLibrary.setModelWriterFactory(modelWriterFactory);
        this.sourceLibrary.setModelWriterFactory(modelWriterFactory);
        return this;
    }

    public ClassLibrary getClassLibrary() {
        return this.sourceLibrary;
    }

    public JavaSource addSource(InputStream stream) throws IOException {
        return this.sourceLibrary.addSource(stream);
    }

    public JavaSource addSource(Reader reader) {
        return this.sourceLibrary.addSource(reader);
    }

    public JavaSource addSource(URL url) throws IOException {
        return this.sourceLibrary.addSource(url);
    }

    public JavaSource addSource(File file) throws IOException {
        return this.sourceLibrary.addSource(file);
    }
}

