/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.java;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.java.StaticRepl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaInterpreter.class);

    public JavaInterpreter(Properties property) {
        super(property);
    }

    public void open() {
    }

    public void close() {
        Stream.of(new File(".").listFiles(f -> f.getAbsolutePath().endsWith(".class"))).forEach(f -> f.delete());
    }

    public InterpreterResult interpret(String code, InterpreterContext context) {
        String generatedClassName = "C" + UUID.randomUUID().toString().replace("-", "");
        try {
            String res = StaticRepl.execute(generatedClassName, code);
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, res);
        }
        catch (Exception e) {
            LOGGER.error("Exception in Interpreter while interpret", e);
            return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
        }
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return Collections.emptyList();
    }
}

