/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.Status;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropPatchMethod
extends DavMethodBase
implements DavConstants {
    private static Logger log = LoggerFactory.getLogger((Class)PropPatchMethod.class);
    private final DavPropertyNameSet propertyNames = new DavPropertyNameSet();
    private DavException responseException;

    public PropPatchMethod(String uri, List changeList) throws IOException {
        super(uri);
        if (changeList == null || changeList.isEmpty()) {
            throw new IllegalArgumentException("PROPPATCH cannot be executed without properties to be set or removed.");
        }
        try {
            Document document = BUILDER_FACTORY.newDocumentBuilder().newDocument();
            Element propUpdateElement = DomUtil.addChildElement(document, "propertyupdate", NAMESPACE);
            Node propElement = null;
            boolean isSet = false;
            Iterator it = changeList.iterator();
            while (it.hasNext()) {
                Object entry = it.next();
                if (entry instanceof DavPropertyName) {
                    DavPropertyName removeName = (DavPropertyName)entry;
                    if (propElement == null || isSet) {
                        isSet = false;
                        propElement = this.getPropElement(propUpdateElement, isSet);
                    }
                    propElement.appendChild(removeName.toXml(document));
                    this.propertyNames.add(removeName);
                    continue;
                }
                if (entry instanceof DavProperty) {
                    DavProperty setProperty = (DavProperty)entry;
                    if (propElement == null || !isSet) {
                        isSet = true;
                        propElement = this.getPropElement(propUpdateElement, isSet);
                    }
                    propElement.appendChild(setProperty.toXml(document));
                    this.propertyNames.add(setProperty.getName());
                    continue;
                }
                throw new IllegalArgumentException("ChangeList may only contain DavPropertyName and DavProperty elements.");
            }
            this.setRequestBody(document);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public PropPatchMethod(String uri, DavPropertySet setProperties, DavPropertyNameSet removeProperties) throws IOException {
        super(uri);
        if (setProperties == null || removeProperties == null) {
            throw new IllegalArgumentException("Neither setProperties nor removeProperties must be null.");
        }
        if (setProperties.isEmpty() && removeProperties.isEmpty()) {
            throw new IllegalArgumentException("Either setProperties or removeProperties can be empty; not both of them.");
        }
        this.propertyNames.addAll(removeProperties);
        DavPropertyName[] setNames = setProperties.getPropertyNames();
        for (int i = 0; i < setNames.length; ++i) {
            this.propertyNames.add(setNames[i]);
        }
        try {
            Document document = BUILDER_FACTORY.newDocumentBuilder().newDocument();
            Element propupdate = DomUtil.addChildElement(document, "propertyupdate", NAMESPACE);
            if (!setProperties.isEmpty()) {
                Element set = DomUtil.addChildElement(propupdate, "set", NAMESPACE);
                set.appendChild(setProperties.toXml(document));
            }
            if (!removeProperties.isEmpty()) {
                Element remove = DomUtil.addChildElement(propupdate, "remove", NAMESPACE);
                remove.appendChild(removeProperties.toXml(document));
            }
            this.setRequestBody(document);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    private Element getPropElement(Element propUpdate, boolean isSet) {
        Element updateEntry = DomUtil.addChildElement(propUpdate, isSet ? "set" : "remove", NAMESPACE);
        return DomUtil.addChildElement(updateEntry, "prop", NAMESPACE);
    }

    public String getName() {
        return "PROPPATCH";
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode == 207 || statusCode == 200;
    }

    protected void processMultiStatusBody(MultiStatus multiStatus, HttpState httpState, HttpConnection httpConnection) {
        MultiStatusResponse[] resp = multiStatus.getResponses();
        if (resp.length != 1) {
            log.warn("Expected a single multi-status response in PROPPATCH.");
        }
        boolean success = true;
        for (int i = 0; i < 1; ++i) {
            DavPropertyNameSet okSet = resp[i].getPropertyNames(200);
            if (okSet.isEmpty()) {
                log.debug("PROPPATCH failed: No 'OK' response found for resource " + resp[i].getHref());
                success = false;
            } else {
                DavPropertyNameIterator it = this.propertyNames.iterator();
                while (it.hasNext()) {
                    DavPropertyName pn = it.nextPropertyName();
                    success = okSet.remove(pn);
                }
            }
            if (okSet.isEmpty()) continue;
            StringBuffer b = new StringBuffer("The following properties outside of the original request where set or removed: ");
            DavPropertyNameIterator it = okSet.iterator();
            while (it.hasNext()) {
                b.append(it.nextPropertyName().toString()).append("; ");
            }
            log.warn(b.toString());
        }
        if (!success) {
            Status[] st = resp[0].getStatus();
            block6: for (int i = 0; i < st.length && this.responseException == null; ++i) {
                switch (st[i].getStatusCode()) {
                    case 424: {
                        continue block6;
                    }
                    default: {
                        this.responseException = new DavException(st[i].getStatusCode());
                    }
                }
            }
        }
    }

    public DavException getResponseException() throws IOException {
        this.checkUsed();
        if (this.getSuccess()) {
            String msg = "Cannot retrieve exception from successful response.";
            log.warn(msg);
            throw new IllegalStateException(msg);
        }
        if (this.responseException != null) {
            return this.responseException;
        }
        return super.getResponseException();
    }
}

