/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store;

import com.microsoft.azure.datalake.store.ADLStoreClient;
import com.microsoft.azure.datalake.store.Core;
import com.microsoft.azure.datalake.store.DirectoryEntry;
import com.microsoft.azure.datalake.store.OperationResponse;
import com.microsoft.azure.datalake.store.RequestOptions;
import com.microsoft.azure.datalake.store.SyncFlag;
import com.microsoft.azure.datalake.store.retrypolicies.ExponentialBackoffPolicy;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADLFileOutputStream
extends OutputStream {
    private static final Logger log = LoggerFactory.getLogger((String)"com.microsoft.azure.datalake.store.ADLFileOutputStream");
    private final String filename;
    private final ADLStoreClient client;
    private final boolean isCreate;
    private final String leaseId;
    private int blocksize = 0x400000;
    private byte[] buffer = null;
    private int cursor = 0;
    private long remoteCursor = 0L;
    private boolean streamClosed = false;
    private boolean lastFlushUpdatedMetadata = false;

    ADLFileOutputStream(String filename, ADLStoreClient client, boolean isCreate, String leaseId) throws IOException {
        this.filename = filename;
        this.client = client;
        this.isCreate = isCreate;
        String string = this.leaseId = leaseId == null ? UUID.randomUUID().toString() : leaseId;
        if (!isCreate) {
            this.initializeAppendStream();
        }
        if (log.isTraceEnabled()) {
            log.trace("ADLFIleOutputStream created for client {} for file {}, create={}", new Object[]{client.getClientId(), filename, isCreate});
        }
    }

    private void initializeAppendStream() throws IOException {
        boolean append0succeeded = this.doZeroLengthAppend(-1L);
        if (!append0succeeded) {
            throw new IOException("Error doing 0-length append for append stream for file " + this.filename);
        }
        DirectoryEntry dirent = this.client.getDirectoryEntry(this.filename);
        if (dirent == null) {
            throw new IOException("Failure getting directoryEntry during append stream creation for file " + this.filename);
        }
        this.remoteCursor = dirent.length;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.streamClosed) {
            throw new IOException("attempting to write to a closed stream;");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (off > b.length || len > b.length - off) {
            throw new IllegalArgumentException("array offset and length are > array size");
        }
        if (log.isTraceEnabled()) {
            log.trace("Stream write of size {} for client {} for file {}", new Object[]{len, this.client.getClientId(), this.filename});
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.blocksize];
        }
        while (len > this.blocksize) {
            this.flush(SyncFlag.DATA);
            this.addToBuffer(b, off, this.blocksize);
            off += this.blocksize;
            len -= this.blocksize;
        }
        if (len > this.buffer.length - this.cursor) {
            this.flush(SyncFlag.DATA);
        }
        this.addToBuffer(b, off, len);
    }

    private void addToBuffer(byte[] b, int off, int len) {
        if (len > this.buffer.length - this.cursor) {
            throw new IllegalArgumentException("invalid buffer copy requested in addToBuffer");
        }
        System.arraycopy(b, off, this.buffer, this.cursor, len);
        this.cursor += len;
    }

    @Override
    public void flush() throws IOException {
        this.flush(SyncFlag.METADATA);
    }

    private void flush(SyncFlag syncFlag) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("flush() with data size {} at offset {} for client {} for file {}", new Object[]{this.cursor, this.remoteCursor, this.client.getClientId(), this.filename});
        }
        if (this.streamClosed) {
            return;
        }
        if (this.cursor == 0 && syncFlag == SyncFlag.DATA) {
            return;
        }
        if (this.cursor == 0 && this.lastFlushUpdatedMetadata) {
            return;
        }
        if (this.buffer == null) {
            this.buffer = new byte[this.blocksize];
        }
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.append(this.filename, this.remoteCursor, this.buffer, 0, this.cursor, this.leaseId, this.leaseId, syncFlag, this.client, opts, resp);
        if (!resp.successful) {
            if (resp.numRetries > 0 && resp.httpResponseCode == 400 && "BadOffsetException".equals(resp.remoteExceptionName)) {
                long expectedRemoteLength = this.remoteCursor + (long)this.cursor;
                boolean append0Succeeded = this.doZeroLengthAppend(expectedRemoteLength);
                if (append0Succeeded) {
                    log.debug("zero-length append succeeded at expected offset (" + expectedRemoteLength + "),  ignoring BadOffsetException for session: " + this.leaseId + ", file: " + this.filename);
                    this.remoteCursor += (long)this.cursor;
                    this.cursor = 0;
                    this.lastFlushUpdatedMetadata = false;
                    return;
                }
                log.debug("Append failed at expected offset(" + expectedRemoteLength + "). Bubbling exception up for session: " + this.leaseId + ", file: " + this.filename);
            }
            throw this.client.getExceptionFromResponse(resp, "Error appending to file " + this.filename);
        }
        this.remoteCursor += (long)this.cursor;
        this.cursor = 0;
        this.lastFlushUpdatedMetadata = syncFlag != SyncFlag.DATA;
    }

    private boolean doZeroLengthAppend(long offset) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.append(this.filename, offset, null, 0, 0, this.leaseId, this.leaseId, SyncFlag.METADATA, this.client, opts, resp);
        return resp.successful;
    }

    public void setBufferSize(int newSize) throws IOException {
        if (newSize <= 0) {
            throw new IllegalArgumentException("Buffer size cannot be zero or less: " + newSize);
        }
        if (newSize == this.blocksize) {
            return;
        }
        if (this.cursor != 0) {
            this.flush(SyncFlag.DATA);
        }
        this.blocksize = newSize;
        this.buffer = null;
    }

    @Override
    public void close() throws IOException {
        if (this.streamClosed) {
            return;
        }
        this.flush(SyncFlag.CLOSE);
        this.streamClosed = true;
        this.buffer = null;
        if (log.isTraceEnabled()) {
            log.trace("Stream closed for client {} for file {}", (Object)this.client.getClientId(), (Object)this.filename);
        }
    }
}

