/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.interpret;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.hubspot.jinjava.interpret.CallStack;
import com.hubspot.jinjava.interpret.ExtendsTagCycleException;
import com.hubspot.jinjava.interpret.FromTagCycleException;
import com.hubspot.jinjava.interpret.ImportTagCycleException;
import com.hubspot.jinjava.interpret.IncludeTagCycleException;
import com.hubspot.jinjava.interpret.MacroTagCycleException;
import com.hubspot.jinjava.interpret.TagCycleException;
import com.hubspot.jinjava.lib.Importable;
import com.hubspot.jinjava.lib.exptest.ExpTest;
import com.hubspot.jinjava.lib.exptest.ExpTestLibrary;
import com.hubspot.jinjava.lib.filter.Filter;
import com.hubspot.jinjava.lib.filter.FilterLibrary;
import com.hubspot.jinjava.lib.fn.ELFunctionDefinition;
import com.hubspot.jinjava.lib.fn.FunctionLibrary;
import com.hubspot.jinjava.lib.fn.MacroFunction;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.lib.tag.TagLibrary;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.util.ScopeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class Context
extends ScopeMap<String, Object> {
    public static final String GLOBAL_MACROS_SCOPE_KEY = "__macros__";
    public static final String IMPORT_RESOURCE_PATH_KEY = "import_resource_path";
    private SetMultimap<String, String> dependencies = HashMultimap.create();
    private Map<Library, Set<String>> disabled;
    private final CallStack extendPathStack;
    private final CallStack importPathStack;
    private final CallStack includePathStack;
    private final CallStack macroStack;
    private final CallStack fromStack;
    private final CallStack currentPathStack;
    private final Set<String> resolvedExpressions = new HashSet<String>();
    private final Set<String> resolvedValues = new HashSet<String>();
    private final Set<String> resolvedFunctions = new HashSet<String>();
    private Set<Node> deferredNodes = new HashSet<Node>();
    private final ExpTestLibrary expTestLibrary;
    private final FilterLibrary filterLibrary;
    private final FunctionLibrary functionLibrary;
    private final TagLibrary tagLibrary;
    private final Context parent;
    private int renderDepth = -1;
    private Boolean autoEscape;
    private List<? extends Node> superBlock;
    private final Stack<String> renderStack = new Stack();
    private boolean validationMode = false;

    public boolean isValidationMode() {
        return this.validationMode;
    }

    public Context setValidationMode(boolean validationMode) {
        this.validationMode = validationMode;
        return this;
    }

    public Context() {
        this(null, null, null);
    }

    public Context(Context parent) {
        this(parent, null, null);
    }

    public Context(Context parent, Map<String, ?> bindings) {
        this(parent, bindings, null);
    }

    public Context(Context parent, Map<String, ?> bindings, Map<Library, Set<String>> disabled) {
        super(parent);
        this.disabled = disabled;
        if (bindings != null) {
            this.putAll(bindings);
        }
        this.parent = parent;
        this.extendPathStack = new CallStack(parent == null ? null : parent.getExtendPathStack(), ExtendsTagCycleException.class);
        this.importPathStack = new CallStack(parent == null ? null : parent.getImportPathStack(), ImportTagCycleException.class);
        this.includePathStack = new CallStack(parent == null ? null : parent.getIncludePathStack(), IncludeTagCycleException.class);
        this.macroStack = new CallStack(parent == null ? null : parent.getMacroStack(), MacroTagCycleException.class);
        this.fromStack = new CallStack(parent == null ? null : parent.getFromStack(), FromTagCycleException.class);
        this.currentPathStack = new CallStack(parent == null ? null : parent.getCurrentPathStack(), TagCycleException.class);
        if (disabled == null) {
            disabled = new HashMap<Library, Set<String>>();
        }
        this.expTestLibrary = new ExpTestLibrary(parent == null, disabled.get((Object)Library.EXP_TEST));
        this.filterLibrary = new FilterLibrary(parent == null, disabled.get((Object)Library.FILTER));
        this.tagLibrary = new TagLibrary(parent == null, disabled.get((Object)Library.TAG));
        this.functionLibrary = new FunctionLibrary(parent == null, disabled.get((Object)Library.FUNCTION));
    }

    public void reset() {
        this.resolvedExpressions.clear();
        this.resolvedValues.clear();
        this.resolvedFunctions.clear();
        this.dependencies = HashMultimap.create();
        this.deferredNodes = new HashSet<Node>();
    }

    public Context getParent() {
        return this.parent;
    }

    public Map<String, Object> getSessionBindings() {
        return this.getScope();
    }

    public Map<String, MacroFunction> getGlobalMacros() {
        HashMap macros = (HashMap)this.getScope().get(GLOBAL_MACROS_SCOPE_KEY);
        if (macros == null) {
            macros = new HashMap();
            this.getScope().put(GLOBAL_MACROS_SCOPE_KEY, macros);
        }
        return macros;
    }

    public void addGlobalMacro(MacroFunction macro) {
        this.getGlobalMacros().put(macro.getName(), macro);
    }

    public MacroFunction getGlobalMacro(String identifier) {
        MacroFunction fn = this.getGlobalMacros().get(identifier);
        if (fn == null && this.parent != null) {
            fn = this.parent.getGlobalMacro(identifier);
        }
        return fn;
    }

    public boolean isGlobalMacro(String identifier) {
        return this.getGlobalMacro(identifier) != null;
    }

    public boolean isAutoEscape() {
        if (this.autoEscape != null) {
            return this.autoEscape;
        }
        if (this.parent != null) {
            return this.parent.isAutoEscape();
        }
        return false;
    }

    public void setAutoEscape(Boolean autoEscape) {
        this.autoEscape = autoEscape;
    }

    public void addResolvedExpression(String expression) {
        this.resolvedExpressions.add(expression);
        if (this.getParent() != null) {
            this.getParent().addResolvedExpression(expression);
        }
    }

    public Set<String> getResolvedExpressions() {
        return ImmutableSet.copyOf(this.resolvedExpressions);
    }

    public boolean wasExpressionResolved(String expression) {
        return this.resolvedExpressions.contains(expression);
    }

    public void addResolvedValue(String value) {
        this.resolvedValues.add(value);
        if (this.getParent() != null) {
            this.getParent().addResolvedValue(value);
        }
    }

    public Set<String> getResolvedValues() {
        return ImmutableSet.copyOf(this.resolvedValues);
    }

    public boolean wasValueResolved(String value) {
        return this.resolvedValues.contains(value);
    }

    public Set<String> getResolvedFunctions() {
        return ImmutableSet.copyOf(this.resolvedFunctions);
    }

    public void addResolvedFunction(String function) {
        this.resolvedFunctions.add(function);
        if (this.getParent() != null) {
            this.getParent().addResolvedFunction(function);
        }
    }

    public void addDeferredNode(Node node) {
        this.deferredNodes.add(node);
        if (this.getParent() != null) {
            this.getParent().addDeferredNode(node);
        }
    }

    public Set<Node> getDeferredNodes() {
        return ImmutableSet.copyOf(this.deferredNodes);
    }

    public List<? extends Node> getSuperBlock() {
        if (this.superBlock != null) {
            return this.superBlock;
        }
        if (this.parent != null) {
            return this.parent.getSuperBlock();
        }
        return null;
    }

    public void setSuperBlock(List<? extends Node> superBlock) {
        this.superBlock = superBlock;
    }

    public void removeSuperBlock() {
        this.superBlock = null;
    }

    public void addResolvedFrom(Context context) {
        context.getResolvedExpressions().forEach(this::addResolvedExpression);
        context.getResolvedFunctions().forEach(this::addResolvedFunction);
        context.getResolvedValues().forEach(this::addResolvedValue);
    }

    @SafeVarargs
    public final void registerClasses(Class<? extends Importable> ... classes) {
        for (Class<? extends Importable> c : classes) {
            if (ExpTest.class.isAssignableFrom(c)) {
                this.expTestLibrary.registerClasses(c);
                continue;
            }
            if (Filter.class.isAssignableFrom(c)) {
                this.filterLibrary.registerClasses(c);
                continue;
            }
            if (!Tag.class.isAssignableFrom(c)) continue;
            this.tagLibrary.registerClasses(c);
        }
    }

    public Collection<ExpTest> getAllExpTests() {
        ArrayList<ExpTest> expTests = new ArrayList<ExpTest>(this.expTestLibrary.entries());
        if (this.parent != null) {
            expTests.addAll(this.parent.getAllExpTests());
        }
        return expTests;
    }

    public ExpTest getExpTest(String name) {
        ExpTest t = this.expTestLibrary.getExpTest(name);
        if (t != null) {
            return t;
        }
        if (this.parent != null) {
            return this.parent.getExpTest(name);
        }
        return null;
    }

    public void registerExpTest(ExpTest t) {
        this.expTestLibrary.addExpTest(t);
    }

    public Collection<Filter> getAllFilters() {
        ArrayList<Filter> filters = new ArrayList<Filter>(this.filterLibrary.entries());
        if (this.parent != null) {
            filters.addAll(this.parent.getAllFilters());
        }
        return filters;
    }

    public Filter getFilter(String name) {
        Filter f = this.filterLibrary.getFilter(name);
        if (f != null) {
            return f;
        }
        if (this.parent != null) {
            return this.parent.getFilter(name);
        }
        return null;
    }

    public void registerFilter(Filter f) {
        this.filterLibrary.addFilter(f);
    }

    public boolean isFunctionDisabled(String name) {
        return this.disabled != null && this.disabled.getOrDefault((Object)Library.FUNCTION, Collections.emptySet()).contains(name);
    }

    public ELFunctionDefinition getFunction(String name) {
        ELFunctionDefinition f = this.functionLibrary.getFunction(name);
        if (f != null) {
            return f;
        }
        if (this.parent != null) {
            return this.parent.getFunction(name);
        }
        return null;
    }

    public Collection<ELFunctionDefinition> getAllFunctions() {
        ArrayList fns = new ArrayList(this.functionLibrary.entries());
        if (this.parent != null) {
            fns.addAll(this.parent.getAllFunctions());
        }
        HashSet disabledFunctions = this.disabled == null ? new HashSet() : (Set)this.disabled.getOrDefault((Object)Library.FUNCTION, new HashSet());
        return fns.stream().filter(f -> !disabledFunctions.contains(f.getName())).collect(Collectors.toList());
    }

    public void registerFunction(ELFunctionDefinition f) {
        this.functionLibrary.addFunction(f);
    }

    public Collection<Tag> getAllTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>(this.tagLibrary.entries());
        if (this.parent != null) {
            tags.addAll(this.parent.getAllTags());
        }
        return tags;
    }

    public Tag getTag(String name) {
        Tag t = this.tagLibrary.getTag(name);
        if (t != null) {
            return t;
        }
        if (this.parent != null) {
            return this.parent.getTag(name);
        }
        return null;
    }

    public void registerTag(Tag t) {
        this.tagLibrary.addTag(t);
    }

    public CallStack getExtendPathStack() {
        return this.extendPathStack;
    }

    public CallStack getImportPathStack() {
        return this.importPathStack;
    }

    public CallStack getIncludePathStack() {
        return this.includePathStack;
    }

    private CallStack getFromStack() {
        return this.fromStack;
    }

    public CallStack getMacroStack() {
        return this.macroStack;
    }

    public CallStack getCurrentPathStack() {
        return this.currentPathStack;
    }

    public void pushFromStack(String path, int lineNumber, int startPosition) {
        this.fromStack.push(path, lineNumber, startPosition);
    }

    public void popFromStack() {
        this.fromStack.pop();
    }

    public int getRenderDepth() {
        if (this.renderDepth != -1) {
            return this.renderDepth;
        }
        if (this.parent != null) {
            return this.parent.getRenderDepth();
        }
        return 0;
    }

    public void setRenderDepth(int renderDepth) {
        this.renderDepth = renderDepth;
    }

    public void pushRenderStack(String template) {
        this.renderStack.push(template);
    }

    public String popRenderStack() {
        return this.renderStack.pop();
    }

    public boolean doesRenderStackContain(String template) {
        return this.renderStack.contains(template);
    }

    public void addDependency(String type, String identification) {
        this.dependencies.get((Object)type).add(identification);
        if (this.parent != null) {
            this.parent.addDependency(type, identification);
        }
    }

    public void addDependencies(SetMultimap<String, String> dependencies) {
        this.dependencies.putAll(dependencies);
        if (this.parent != null) {
            this.parent.addDependencies(dependencies);
        }
    }

    public SetMultimap<String, String> getDependencies() {
        return this.dependencies;
    }

    public static enum Library {
        EXP_TEST,
        FILTER,
        FUNCTION,
        TAG;

    }
}

