/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.definition.internal;

import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.DefinitionList;
import com.vladsch.flexmark.ext.definition.DefinitionTerm;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.CoreNodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DefinitionNodeRenderer
implements NodeRenderer {
    private final ListOptions listOptions;

    public DefinitionNodeRenderer(DataHolder options) {
        this.listOptions = ListOptions.get((DataHolder)options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(DefinitionList.class, this::render));
        set.add(new NodeRenderingHandler(DefinitionTerm.class, this::render));
        set.add(new NodeRenderingHandler(DefinitionItem.class, this::render));
        return set;
    }

    private void render(DefinitionList node, NodeRendererContext context, HtmlWriter html) {
        ((HtmlWriter)html.withAttr().tag((CharSequence)"dl")).indent();
        context.renderChildren((Node)node);
        ((HtmlWriter)html.unIndent()).tag((CharSequence)"/dl");
    }

    private void render(DefinitionTerm node, NodeRendererContext context, HtmlWriter html) {
        Node childText = node.getFirstChild();
        if (childText != null) {
            ((HtmlWriter)html.srcPosWithEOL(node.getChars()).withAttr(CoreNodeRenderer.TIGHT_LIST_ITEM).withCondIndent()).tagLine((CharSequence)"dt", () -> {
                html.text((CharSequence)node.getMarkerSuffix().unescape());
                context.renderChildren((Node)node);
            });
        }
    }

    private void render(DefinitionItem node, NodeRendererContext context, HtmlWriter html) {
        if (this.listOptions.isTightListItem((ListItem)node)) {
            ((HtmlWriter)html.srcPosWithEOL(node.getChars()).withAttr(CoreNodeRenderer.TIGHT_LIST_ITEM).withCondIndent()).tagLine((CharSequence)"dd", () -> {
                html.text((CharSequence)node.getMarkerSuffix().unescape());
                context.renderChildren((Node)node);
            });
        } else {
            html.srcPosWithEOL(node.getChars()).withAttr(CoreNodeRenderer.LOOSE_LIST_ITEM).tagIndent((CharSequence)"dd", () -> {
                html.text((CharSequence)node.getMarkerSuffix().unescape());
                context.renderChildren((Node)node);
            });
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new DefinitionNodeRenderer(options);
        }
    }
}

