/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.spotify.docker.client.messages.swarm.EndpointSpec;
import com.spotify.docker.client.messages.swarm.PortConfig;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.docker.client.shaded.com.google.common.collect.ImmutableList;
import com.spotify.docker.client.shaded.javax.annotation.Nullable;
import java.util.List;

final class AutoValue_EndpointSpec
extends EndpointSpec {
    private final EndpointSpec.Mode mode;
    private final ImmutableList<PortConfig> ports;

    private AutoValue_EndpointSpec(@Nullable EndpointSpec.Mode mode, ImmutableList<PortConfig> ports) {
        this.mode = mode;
        this.ports = ports;
    }

    @Override
    @Nullable
    @JsonProperty(value="Mode")
    public EndpointSpec.Mode mode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="Ports")
    public ImmutableList<PortConfig> ports() {
        return this.ports;
    }

    public String toString() {
        return "EndpointSpec{mode=" + (Object)((Object)this.mode) + ", ports=" + this.ports + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EndpointSpec) {
            EndpointSpec that = (EndpointSpec)o;
            return (this.mode == null ? that.mode() == null : this.mode.equals((Object)that.mode())) && this.ports.equals(that.ports());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.mode == null ? 0 : this.mode.hashCode();
        h *= 1000003;
        return h ^= this.ports.hashCode();
    }

    @Override
    public EndpointSpec.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends EndpointSpec.Builder {
        private EndpointSpec.Mode mode;
        private ImmutableList.Builder<PortConfig> portsBuilder$;
        private ImmutableList<PortConfig> ports;

        Builder() {
            this.ports = ImmutableList.of();
        }

        Builder(EndpointSpec source) {
            this.mode = source.mode();
            this.ports = source.ports();
        }

        @Override
        public EndpointSpec.Builder mode(@Nullable EndpointSpec.Mode mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public EndpointSpec.Builder ports(PortConfig ... ports) {
            if (this.portsBuilder$ != null) {
                throw new IllegalStateException("Cannot set ports after calling portsBuilder()");
            }
            this.ports = ImmutableList.copyOf(ports);
            return this;
        }

        @Override
        public EndpointSpec.Builder ports(List<PortConfig> ports) {
            if (this.portsBuilder$ != null) {
                throw new IllegalStateException("Cannot set ports after calling portsBuilder()");
            }
            this.ports = ImmutableList.copyOf(ports);
            return this;
        }

        @Override
        public ImmutableList.Builder<PortConfig> portsBuilder() {
            if (this.portsBuilder$ == null) {
                this.portsBuilder$ = ImmutableList.builder();
                this.portsBuilder$.addAll(this.ports);
                this.ports = null;
            }
            return this.portsBuilder$;
        }

        @Override
        public EndpointSpec build() {
            if (this.portsBuilder$ != null) {
                this.ports = this.portsBuilder$.build();
            }
            return new AutoValue_EndpointSpec(this.mode, this.ports);
        }
    }
}

