/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest.exception;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.zeppelin.rest.message.gson.ExceptionSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class WebApplicationExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebApplicationException.class);
    private final Gson gson;

    public WebApplicationExceptionMapper() {
        GsonBuilder gsonBuilder = new GsonBuilder().enableComplexMapKeySerialization();
        gsonBuilder.registerTypeHierarchyAdapter(Exception.class, (Object)new ExceptionSerializer());
        this.gson = gsonBuilder.create();
    }

    public Response toResponse(Throwable exception) {
        if (exception instanceof WebApplicationException) {
            return ((WebApplicationException)exception).getResponse();
        }
        LOGGER.error("Error response", exception);
        return Response.status((int)500).entity((Object)this.gson.toJson((Object)exception)).build();
    }
}

