/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergePolicyWrapper;
import org.apache.lucene.index.MergeReaderWrapper;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.SortingLeafReader;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.packed.PackedLongValues;

public final class SortingMergePolicy
extends MergePolicyWrapper {
    public static final String SORTER_ID_PROP = "sorter";
    final Sorter sorter;
    final Sort sort;

    public static boolean isSorted(LeafReader reader, Sort sort) {
        String description = SortingMergePolicy.getSortDescription(reader);
        return description != null && description.equals(sort.toString());
    }

    private static String getSortDescription(LeafReader reader) {
        if (reader instanceof SegmentReader) {
            SegmentReader segReader = (SegmentReader)reader;
            Map<String, String> diagnostics = segReader.getSegmentInfo().info.getDiagnostics();
            if (diagnostics != null) {
                return diagnostics.get(SORTER_ID_PROP);
            }
        } else if (reader instanceof FilterLeafReader) {
            return SortingMergePolicy.getSortDescription(FilterLeafReader.unwrap(reader));
        }
        return null;
    }

    private MergePolicy.MergeSpecification sortedMergeSpecification(MergePolicy.MergeSpecification specification, InfoStream infoStream) {
        if (specification == null) {
            return null;
        }
        SortingMergeSpecification sortingSpec = new SortingMergeSpecification(infoStream);
        for (MergePolicy.OneMerge merge : specification.merges) {
            ((MergePolicy.MergeSpecification)sortingSpec).add(merge);
        }
        return sortingSpec;
    }

    public SortingMergePolicy(MergePolicy in, Sort sort) {
        super(in);
        this.sorter = new Sorter(sort);
        this.sort = sort;
    }

    public Sort getSort() {
        return this.sort;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.sortedMergeSpecification(this.in.findMerges(mergeTrigger, segmentInfos, writer), writer.infoStream);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer) throws IOException {
        return this.sortedMergeSpecification(this.in.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge, writer), writer.infoStream);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.sortedMergeSpecification(this.in.findForcedDeletesMerges(segmentInfos, writer), writer.infoStream);
    }

    @Override
    public String toString() {
        return "SortingMergePolicy(" + this.in + ", sorter=" + this.sorter + ")";
    }

    class SortingMergeSpecification
    extends MergePolicy.MergeSpecification {
        final InfoStream infoStream;

        SortingMergeSpecification(InfoStream infoStream) {
            this.infoStream = infoStream;
        }

        @Override
        public void add(MergePolicy.OneMerge merge) {
            super.add(new SortingOneMerge(merge.segments, this.infoStream));
        }

        @Override
        public String segString(Directory dir) {
            return "SortingMergeSpec(" + super.segString(dir) + ", sorter=" + SortingMergePolicy.this.sorter + ")";
        }
    }

    class SortingOneMerge
    extends MergePolicy.OneMerge {
        List<CodecReader> unsortedReaders;
        Sorter.DocMap docMap;
        LeafReader sortedView;
        final InfoStream infoStream;

        SortingOneMerge(List<SegmentCommitInfo> segments, InfoStream infoStream) {
            super(segments);
            this.infoStream = infoStream;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<CodecReader> getMergeReaders() throws IOException {
            if (this.unsortedReaders == null) {
                void var2_6;
                this.unsortedReaders = super.getMergeReaders();
                if (this.infoStream.isEnabled("SMP")) {
                    this.infoStream.message("SMP", "sorting " + this.unsortedReaders);
                    for (LeafReader leafReader : this.unsortedReaders) {
                        void var3_7;
                        String string = SortingMergePolicy.getSortDescription(leafReader);
                        if (string == null) {
                            String string2 = "not sorted";
                        }
                        this.infoStream.message("SMP", "seg=" + leafReader + " " + (String)var3_7);
                    }
                }
                ArrayList<void> wrapped = new ArrayList<void>(this.unsortedReaders.size());
                for (LeafReader leafReader : this.unsortedReaders) {
                    void var3_13;
                    if (leafReader instanceof SegmentReader) {
                        MergeReaderWrapper mergeReaderWrapper = new MergeReaderWrapper((SegmentReader)leafReader);
                    }
                    wrapped.add(var3_13);
                }
                if (wrapped.size() == 1) {
                    LeafReader leafReader = (LeafReader)wrapped.get(0);
                } else {
                    MultiReader multiReader = new MultiReader((IndexReader[])wrapped.toArray(new LeafReader[wrapped.size()]));
                    SlowCompositeReaderWrapper slowCompositeReaderWrapper = new SlowCompositeReaderWrapper(multiReader, true);
                }
                this.docMap = SortingMergePolicy.this.sorter.sort((LeafReader)var2_6);
                this.sortedView = SortingLeafReader.wrap((LeafReader)var2_6, this.docMap);
            }
            if (this.docMap == null) {
                if (this.infoStream.isEnabled("SMP")) {
                    this.infoStream.message("SMP", "readers already sorted, omitting sort");
                }
                return this.unsortedReaders;
            }
            if (this.infoStream.isEnabled("SMP")) {
                this.infoStream.message("SMP", "sorting readers by " + SortingMergePolicy.this.sort);
            }
            return Collections.singletonList(SlowCodecReaderWrapper.wrap(this.sortedView));
        }

        @Override
        public void setMergeInfo(SegmentCommitInfo info) {
            Map<String, String> diagnostics = info.info.getDiagnostics();
            diagnostics.put(SortingMergePolicy.SORTER_ID_PROP, SortingMergePolicy.this.sorter.getID());
            super.setMergeInfo(info);
        }

        private PackedLongValues getDeletes(List<CodecReader> readers) {
            PackedLongValues.Builder deletes = PackedLongValues.monotonicBuilder(0.0f);
            int deleteCount = 0;
            for (LeafReader leafReader : readers) {
                int maxDoc = leafReader.maxDoc();
                Bits liveDocs = leafReader.getLiveDocs();
                for (int i = 0; i < maxDoc; ++i) {
                    if (liveDocs != null && !liveDocs.get(i)) {
                        ++deleteCount;
                        continue;
                    }
                    deletes.add(deleteCount);
                }
            }
            return deletes.build();
        }

        @Override
        public MergePolicy.DocMap getDocMap(final MergeState mergeState) {
            if (this.unsortedReaders == null) {
                throw new IllegalStateException();
            }
            if (this.docMap == null) {
                return super.getDocMap(mergeState);
            }
            assert (mergeState.docMaps.length == 1);
            final PackedLongValues deletes = this.getDeletes(this.unsortedReaders);
            return new MergePolicy.DocMap(){

                @Override
                public int map(int old) {
                    int oldWithDeletes = old + (int)deletes.get(old);
                    int newWithDeletes = SortingOneMerge.this.docMap.oldToNew(oldWithDeletes);
                    return mergeState.docMaps[0].get(newWithDeletes);
                }
            };
        }

        public String toString() {
            return "SortingMergePolicy.SortingOneMerge(segments=" + this.segString() + " sort=" + SortingMergePolicy.this.sort + ")";
        }
    }
}

