/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQueryImpl;
import org.apache.lucene.spatial.geopoint.search.GeoPointInPolygonQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.util.GeoRelationUtils;

final class GeoPointInPolygonQueryImpl
extends GeoPointInBBoxQueryImpl {
    private final GeoPointInPolygonQuery polygonQuery;

    GeoPointInPolygonQueryImpl(String field, GeoPointField.TermEncoding termEncoding, GeoPointInPolygonQuery q, double minLon, double minLat, double maxLon, double maxLat) {
        super(field, termEncoding, minLon, minLat, maxLon, maxLat);
        this.polygonQuery = q;
    }

    @Override
    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("cannot change rewrite method");
    }

    @Override
    protected GeoPointMultiTermQuery.CellComparator newCellComparator() {
        return new GeoPolygonCellComparator(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointInPolygonQueryImpl that = (GeoPointInPolygonQueryImpl)o;
        return !(this.polygonQuery == null ? that.polygonQuery != null : !this.polygonQuery.equals(that.polygonQuery));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.polygonQuery != null ? this.polygonQuery.hashCode() : 0);
        return result;
    }

    private final class GeoPolygonCellComparator
    extends GeoPointMultiTermQuery.CellComparator {
        GeoPolygonCellComparator(GeoPointMultiTermQuery query) {
            super(query);
        }

        @Override
        protected boolean cellCrosses(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoRelationUtils.rectCrossesPolyApprox(minLon, minLat, maxLon, maxLat, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.x, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.y, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.minLon, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.minLat, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.maxLon, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.maxLat);
        }

        @Override
        protected boolean cellWithin(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoRelationUtils.rectWithinPolyApprox(minLon, minLat, maxLon, maxLat, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.x, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.y, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.minLon, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.minLat, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.maxLon, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.maxLat);
        }

        @Override
        protected boolean cellIntersectsShape(double minLon, double minLat, double maxLon, double maxLat) {
            return this.cellContains(minLon, minLat, maxLon, maxLat) || this.cellWithin(minLon, minLat, maxLon, maxLat) || this.cellCrosses(minLon, minLat, maxLon, maxLat);
        }

        @Override
        protected boolean postFilter(double lon, double lat) {
            return GeoRelationUtils.pointInPolygon(((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.x, ((GeoPointInPolygonQueryImpl)GeoPointInPolygonQueryImpl.this).polygonQuery.y, lat, lon);
        }
    }
}

