/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointTermsEnum;
import org.apache.lucene.spatial.util.GeoEncodingUtils;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

final class GeoPointPrefixTermsEnum
extends GeoPointTermsEnum {
    private final long start;
    private short shift;
    private long currStart;
    private long currEnd;
    private final Range nextRange;
    private boolean hasNext;
    private boolean withinOnly;
    private long lastWithin;

    public GeoPointPrefixTermsEnum(TermsEnum tenum, GeoPointMultiTermQuery query) {
        super(tenum, query);
        this.nextRange = new Range(-1L, this.shift, true);
        this.hasNext = false;
        this.withinOnly = false;
        this.start = GeoEncodingUtils.mortonHash(query.minLon, query.minLat);
        this.currentRange = new Range(0L, this.shift, true);
        this.shift = this.maxShift;
        long mask = (1L << this.shift) - 1L;
        this.currStart = this.start & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.currEnd = this.currStart | mask;
    }

    private boolean within(double minLon, double minLat, double maxLon, double maxLat) {
        return this.relationImpl.cellWithin(minLon, minLat, maxLon, maxLat);
    }

    private boolean boundary(double minLon, double minLat, double maxLon, double maxLat) {
        return this.shift == this.maxShift && this.relationImpl.cellIntersectsShape(minLon, minLat, maxLon, maxLat);
    }

    private boolean nextWithin() {
        if (!this.withinOnly) {
            return false;
        }
        this.currStart += 1L << this.shift;
        this.setNextRange(false);
        this.currentRange.set(this.nextRange);
        this.hasNext = true;
        boolean bl = this.withinOnly = this.lastWithin != this.currStart;
        if (!this.withinOnly) {
            this.advanceVariables();
        }
        return true;
    }

    private void nextRelation() {
        double minLon = GeoEncodingUtils.mortonUnhashLon(this.currStart);
        double minLat = GeoEncodingUtils.mortonUnhashLat(this.currStart);
        do {
            double maxLat;
            double maxLon;
            boolean isWithin;
            if ((isWithin = this.within(minLon, minLat, maxLon = GeoEncodingUtils.mortonUnhashLon(this.currEnd), maxLat = GeoEncodingUtils.mortonUnhashLat(this.currEnd))) || this.boundary(minLon, minLat, maxLon, maxLat)) {
                int m;
                if (!isWithin || (m = this.shift % 9) == 0) {
                    this.setNextRange(!isWithin);
                    this.advanceVariables();
                    break;
                }
                if (this.shift < 54) {
                    this.withinOnly = true;
                    this.shift = (short)(this.shift - m);
                    this.lastWithin = this.currEnd & ((1L << this.shift) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
                    this.setNextRange(false);
                    break;
                }
            }
            if (isWithin || this.relationImpl.cellIntersectsMBR(minLon, minLat, maxLon, maxLat) && this.shift != this.maxShift) {
                this.shift = (short)(this.shift - 1);
                this.currEnd = this.currStart | (1L << this.shift) - 1L;
                continue;
            }
            this.advanceVariables();
            minLon = GeoEncodingUtils.mortonUnhashLon(this.currStart);
            minLat = GeoEncodingUtils.mortonUnhashLat(this.currStart);
        } while (this.shift < 63);
    }

    private void setNextRange(boolean boundary) {
        this.nextRange.start = this.currStart;
        this.nextRange.shift = this.shift;
        this.nextRange.boundary = boundary;
    }

    private void advanceVariables() {
        long shiftMask = 1L << this.shift;
        while ((this.currStart & shiftMask) == shiftMask) {
            this.shift = (short)(this.shift + 1);
            shiftMask = 1L << this.shift;
        }
        long shiftMOne = shiftMask - 1L;
        this.currStart = this.currStart & (shiftMOne ^ 0xFFFFFFFFFFFFFFFFL) | shiftMask;
        this.currEnd = this.currStart | shiftMOne;
    }

    @Override
    protected final BytesRef peek() {
        this.nextRange.fillBytesRef(this.nextSubRangeBRB);
        return super.peek();
    }

    protected void seek(long term, short res) {
        if (term < this.currStart && res < this.maxShift) {
            throw new IllegalArgumentException("trying to seek backwards");
        }
        if (term == this.currStart) {
            return;
        }
        this.shift = res;
        this.currStart = term;
        this.currEnd = this.currStart | (1L << this.shift) - 1L;
        this.withinOnly = false;
    }

    @Override
    protected void nextRange() {
        this.hasNext = false;
        super.nextRange();
    }

    @Override
    protected final boolean hasNext() {
        if (this.hasNext || this.nextWithin()) {
            return true;
        }
        this.nextRelation();
        if (this.currentRange.compareTo(this.nextRange) != 0) {
            this.currentRange.set(this.nextRange);
            this.hasNext = true;
            return true;
        }
        return false;
    }

    @Override
    protected final BytesRef nextSeekTerm(BytesRef term) {
        while (this.hasNext()) {
            this.nextRange();
            if (term == null) {
                return this.currentCell;
            }
            int comparison = term.compareTo(this.currentCell);
            if (comparison > 0) {
                this.seek(GeoEncodingUtils.prefixCodedToGeoCoded(term), (short)(64 - GeoEncodingUtils.getPrefixCodedShift(term)));
                continue;
            }
            return this.currentCell;
        }
        return null;
    }

    @Override
    protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
        while (this.currentCell == null || term.compareTo(this.currentCell) > 0) {
            if (!this.hasNext()) {
                return FilteredTermsEnum.AcceptStatus.END;
            }
            int peekCompare = term.compareTo(this.peek());
            if (peekCompare < 0) {
                return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
            }
            if (peekCompare > 0) {
                this.seek(GeoEncodingUtils.prefixCodedToGeoCoded(term), (short)(64 - GeoEncodingUtils.getPrefixCodedShift(term)));
            }
            this.nextRange();
        }
        return FilteredTermsEnum.AcceptStatus.YES;
    }

    protected final class Range
    extends GeoPointTermsEnum.BaseRange {
        public Range(long start, short res, boolean boundary) {
            super(GeoPointPrefixTermsEnum.this, start, res, boundary);
        }

        @Override
        protected void fillBytesRef(BytesRefBuilder result) {
            assert (result != null);
            GeoEncodingUtils.geoCodedToPrefixCoded(this.start, this.shift, result);
        }
    }
}

