/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.spatial.prefix.AbstractPrefixTreeQuery;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.BytesRef;

public abstract class AbstractVisitingPrefixTreeQuery
extends AbstractPrefixTreeQuery {
    protected final int prefixGridScanLevel;

    public AbstractVisitingPrefixTreeQuery(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel) {
        super(queryShape, fieldName, grid, detailLevel);
        this.prefixGridScanLevel = Math.max(0, Math.min(prefixGridScanLevel, grid.getMaxLevels() - 1));
        assert (detailLevel <= grid.getMaxLevels());
    }

    protected static class VNode {
        final VNode parent;
        Iterator<VNode> children;
        Cell cell;

        VNode(VNode parent) {
            this.parent = parent;
        }

        void reset(Cell cell) {
            assert (cell != null);
            this.cell = cell;
            assert (this.children == null);
        }
    }

    public abstract class VisitorTemplate
    extends AbstractPrefixTreeQuery.BaseTermsEnumTraverser {
        private VNode curVNode;
        private BytesRef curVNodeTerm;
        private BytesRef thisTerm;
        private Cell indexedCell;

        public VisitorTemplate(LeafReaderContext context) throws IOException {
            super(context);
            this.curVNodeTerm = new BytesRef();
        }

        /*
         * Enabled aggressive block sorting
         */
        public DocIdSet getDocIdSet() throws IOException {
            assert (this.curVNode == null) : "Called more than once?";
            if (this.termsEnum == null) {
                return null;
            }
            if (!this.nextTerm()) {
                return null;
            }
            this.curVNode = new VNode(null);
            this.curVNode.reset(AbstractVisitingPrefixTreeQuery.this.grid.getWorldCell());
            this.start();
            this.addIntersectingChildren();
            while (this.thisTerm != null) {
                int compare;
                if (this.curVNode.children != null) {
                    assert (this.curVNode.children.hasNext());
                    this.preSiblings(this.curVNode);
                    this.curVNode = this.curVNode.children.next();
                } else {
                    VNode parentVNode = this.curVNode.parent;
                    while (true) {
                        if (parentVNode == null) {
                            return this.finish();
                        }
                        if (parentVNode.children.hasNext()) {
                            this.curVNode = parentVNode.children.next();
                            break;
                        }
                        this.postSiblings(parentVNode);
                        parentVNode.children = null;
                        parentVNode = parentVNode.parent;
                    }
                }
                if ((compare = this.indexedCell.compareToNoLeaf(this.curVNode.cell)) > 0) continue;
                if (compare < 0) {
                    this.curVNode.cell.getTokenBytesNoLeaf(this.curVNodeTerm);
                    TermsEnum.SeekStatus seekStatus = this.termsEnum.seekCeil(this.curVNodeTerm);
                    if (seekStatus == TermsEnum.SeekStatus.END) {
                        return this.finish();
                    }
                    this.thisTerm = this.termsEnum.term();
                    this.indexedCell = AbstractVisitingPrefixTreeQuery.this.grid.readCell(this.thisTerm, this.indexedCell);
                    if (seekStatus == TermsEnum.SeekStatus.NOT_FOUND && (!this.indexedCell.isLeaf() || this.indexedCell.compareToNoLeaf(this.curVNode.cell) != 0)) continue;
                }
                if (this.indexedCell.isLeaf()) {
                    this.visitLeaf(this.indexedCell);
                    if (this.nextTerm()) continue;
                    return this.finish();
                }
                boolean descend = this.visitPrefix(this.curVNode.cell);
                if (!this.nextTerm()) {
                    return this.finish();
                }
                if (this.indexedCell.isLeaf() && this.indexedCell.getLevel() == this.curVNode.cell.getLevel()) {
                    this.visitLeaf(this.indexedCell);
                    if (!this.nextTerm()) {
                        return this.finish();
                    }
                }
                if (!descend) continue;
                this.addIntersectingChildren();
            }
            return this.finish();
        }

        private void addIntersectingChildren() throws IOException {
            boolean scan;
            assert (this.thisTerm != null);
            Cell cell = this.curVNode.cell;
            if (cell.getLevel() >= AbstractVisitingPrefixTreeQuery.this.detailLevel) {
                throw new IllegalStateException("Spatial logic error");
            }
            boolean bl = scan = cell.getLevel() >= AbstractVisitingPrefixTreeQuery.this.prefixGridScanLevel;
            if (!scan) {
                CellIterator subCellsIter = this.findSubCellsToVisit(cell);
                if (!subCellsIter.hasNext()) {
                    return;
                }
                this.curVNode.children = new VNodeCellIterator(subCellsIter, new VNode(this.curVNode));
            } else {
                this.scan(AbstractVisitingPrefixTreeQuery.this.detailLevel);
            }
        }

        protected CellIterator findSubCellsToVisit(Cell cell) {
            return cell.getNextLevelCells(AbstractVisitingPrefixTreeQuery.this.queryShape);
        }

        protected void scan(int scanDetailLevel) throws IOException {
            while (this.curVNode.cell.isPrefixOf(this.indexedCell)) {
                if (this.indexedCell.getLevel() == scanDetailLevel || this.indexedCell.getLevel() < scanDetailLevel && this.indexedCell.isLeaf()) {
                    this.visitScanned(this.indexedCell);
                }
                if (this.nextTerm()) continue;
                break;
            }
        }

        private boolean nextTerm() throws IOException {
            this.thisTerm = this.termsEnum.next();
            if (this.thisTerm == null) {
                return false;
            }
            this.indexedCell = AbstractVisitingPrefixTreeQuery.this.grid.readCell(this.thisTerm, this.indexedCell);
            return true;
        }

        protected abstract void start() throws IOException;

        protected abstract DocIdSet finish() throws IOException;

        protected abstract boolean visitPrefix(Cell var1) throws IOException;

        protected abstract void visitLeaf(Cell var1) throws IOException;

        protected void visitScanned(Cell cell) throws IOException {
            SpatialRelation relate = cell.getShape().relate(AbstractVisitingPrefixTreeQuery.this.queryShape);
            if (relate.intersects()) {
                cell.setShapeRel(relate);
                if (cell.isLeaf()) {
                    this.visitLeaf(cell);
                } else {
                    this.visitPrefix(cell);
                }
            }
        }

        protected void preSiblings(VNode vNode) throws IOException {
        }

        protected void postSiblings(VNode vNode) throws IOException {
        }

        private class VNodeCellIterator
        implements Iterator<VNode> {
            final Iterator<Cell> cellIter;
            private final VNode vNode;

            VNodeCellIterator(Iterator<Cell> cellIter, VNode vNode) {
                this.cellIter = cellIter;
                this.vNode = vNode;
            }

            @Override
            public boolean hasNext() {
                return this.cellIter.hasNext();
            }

            @Override
            public VNode next() {
                assert (this.hasNext());
                this.vNode.reset(this.cellIter.next());
                return this.vNode;
            }

            @Override
            public void remove() {
            }
        }
    }
}

