/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import org.apache.lucene.spatial.util.GeoUtils;
import org.apache.lucene.util.SloppyMath;

public class GeoProjectionUtils {
    public static final double SEMIMAJOR_AXIS = 6378137.0;
    public static final double FLATTENING = 0.0033528106647474805;
    public static final double SEMIMINOR_AXIS = 6356752.314245179;
    public static final double ECCENTRICITY = StrictMath.sqrt(0.0066943799901413165);
    public static final double SEMIMAJOR_AXIS2 = 4.0680631590769E13;
    public static final double SEMIMINOR_AXIS2 = 4.0408299984661445E13;
    private static final double E2 = 0.006694379990141316;
    private static final double EP2 = 0.006739496742276434;
    public static final double MIN_LON_RADIANS = -Math.PI;
    public static final double MIN_LAT_RADIANS = -1.5707963267948966;
    public static final double MAX_LON_RADIANS = Math.PI;
    public static final double MAX_LAT_RADIANS = 1.5707963267948966;

    private GeoProjectionUtils() {
    }

    public static final double[] ecfToLLA(double x, double y, double z, double[] lla) {
        boolean atPole = false;
        double ad_c = 1.0026;
        double cos67P5 = 0.3826834323650898;
        if (lla == null) {
            lla = new double[3];
        }
        if (x != 0.0) {
            lla[0] = StrictMath.atan2(y, x);
        } else if (y > 0.0) {
            lla[0] = 1.5707963267948966;
        } else if (y < 0.0) {
            lla[0] = -1.5707963267948966;
        } else {
            atPole = true;
            lla[0] = 0.0;
            if (z > 0.0) {
                lla[1] = 1.5707963267948966;
            } else if (z < 0.0) {
                lla[1] = -1.5707963267948966;
            } else {
                lla[1] = 1.5707963267948966;
                lla[2] = -6356752.314245179;
                return lla;
            }
        }
        double w2 = x * x + y * y;
        double w = StrictMath.sqrt(w2);
        double t0 = z * 1.0026;
        double s0 = StrictMath.sqrt(t0 * t0 + w2);
        double sinB0 = t0 / s0;
        double cosB0 = w / s0;
        double sin3B0 = sinB0 * sinB0 * sinB0;
        double t1 = z + 42841.31151331357 * sin3B0;
        double sum = w - 42697.67270717996 * cosB0 * cosB0 * cosB0;
        double s1 = StrictMath.sqrt(t1 * t1 + sum * sum);
        double sinP1 = t1 / s1;
        double cosP1 = sum / s1;
        double rn = 6378137.0 / StrictMath.sqrt(1.0 - 0.006694379990141316 * sinP1 * sinP1);
        lla[2] = cosP1 >= 0.3826834323650898 ? w / cosP1 - rn : (cosP1 <= -0.3826834323650898 ? w / -cosP1 - rn : z / sinP1 + rn * -0.9933056200098587);
        if (!atPole) {
            lla[1] = StrictMath.atan(sinP1 / cosP1);
        }
        lla[0] = 57.29577951308232 * lla[0];
        lla[1] = 57.29577951308232 * lla[1];
        return lla;
    }

    public static final double[] llaToECF(double lon, double lat, double alt, double[] ecf) {
        lon = Math.PI / 180 * lon;
        lat = Math.PI / 180 * lat;
        double sl = SloppyMath.sin(lat);
        double s2 = sl * sl;
        double cl = SloppyMath.cos(lat);
        if (ecf == null) {
            ecf = new double[3];
        }
        if (lat < -1.5707963267948966 && lat > -1.5723671231216914) {
            lat = -1.5707963267948966;
        } else if (lat > 1.5707963267948966 && lat < 1.5723671231216914) {
            lat = 1.5707963267948966;
        }
        assert (lat >= -1.5707963267948966 || lat <= 1.5707963267948966);
        if (lon > Math.PI) {
            lon -= Math.PI * 2;
        }
        double rn = 6378137.0 / StrictMath.sqrt(1.0 - 0.006694379990141316 * s2);
        ecf[0] = (rn + alt) * cl * SloppyMath.cos(lon);
        ecf[1] = (rn + alt) * cl * SloppyMath.sin(lon);
        ecf[2] = (rn * 0.9933056200098587 + alt) * sl;
        return ecf;
    }

    public static double[] llaToENU(double lon, double lat, double alt, double centerLon, double centerLat, double centerAlt, double[] enu) {
        if (enu == null) {
            enu = new double[3];
        }
        double[] ecf = GeoProjectionUtils.llaToECF(lon, lat, alt, null);
        return GeoProjectionUtils.ecfToENU(ecf[0], ecf[1], ecf[2], centerLon, centerLat, centerAlt, enu);
    }

    public static double[] enuToLLA(double x, double y, double z, double centerLon, double centerLat, double centerAlt, double[] lla) {
        if (lla == null) {
            lla = new double[3];
        }
        lla = GeoProjectionUtils.enuToECF(x, y, z, centerLon, centerLat, centerAlt, lla);
        return GeoProjectionUtils.ecfToLLA(lla[0], lla[1], lla[2], lla);
    }

    public static double[] ecfToENU(double x, double y, double z, double centerLon, double centerLat, double centerAlt, double[] enu) {
        if (enu == null) {
            enu = new double[3];
        }
        double[][] phi = GeoProjectionUtils.createPhiTransform(centerLon, centerLat, null);
        double[] originECF = GeoProjectionUtils.llaToECF(centerLon, centerLat, centerAlt, null);
        double[] originENU = new double[]{phi[0][0] * originECF[0] + phi[0][1] * originECF[1] + phi[0][2] * originECF[2], phi[1][0] * originECF[0] + phi[1][1] * originECF[1] + phi[1][2] * originECF[2], phi[2][0] * originECF[0] + phi[2][1] * originECF[1] + phi[2][2] * originECF[2]};
        enu[0] = phi[0][0] * x + phi[0][1] * y + phi[0][2] * z - originENU[0];
        enu[1] = phi[1][0] * x + phi[1][1] * y + phi[1][2] * z - originENU[1];
        enu[2] = phi[2][0] * x + phi[2][1] * y + phi[2][2] * z - originENU[2];
        return enu;
    }

    public static double[] enuToECF(double x, double y, double z, double centerLon, double centerLat, double centerAlt, double[] ecf) {
        if (ecf == null) {
            ecf = new double[3];
        }
        double[][] phi = GeoProjectionUtils.createTransposedPhiTransform(centerLon, centerLat, null);
        double[] ecfOrigin = GeoProjectionUtils.llaToECF(centerLon, centerLat, centerAlt, null);
        ecf[0] = phi[0][0] * x + phi[0][1] * y + phi[0][2] * z + ecfOrigin[0];
        ecf[1] = phi[1][0] * x + phi[1][1] * y + phi[1][2] * z + ecfOrigin[1];
        ecf[2] = phi[2][0] * x + phi[2][1] * y + phi[2][2] * z + ecfOrigin[2];
        return ecf;
    }

    private static double[][] createPhiTransform(double originLon, double originLat, double[][] phiMatrix) {
        if (phiMatrix == null) {
            phiMatrix = new double[3][3];
        }
        originLon = Math.PI / 180 * originLon;
        originLat = Math.PI / 180 * originLat;
        double sLon = SloppyMath.sin(originLon);
        double cLon = SloppyMath.cos(originLon);
        double sLat = SloppyMath.sin(originLat);
        double cLat = SloppyMath.cos(originLat);
        phiMatrix[0][0] = -sLon;
        phiMatrix[0][1] = cLon;
        phiMatrix[0][2] = 0.0;
        phiMatrix[1][0] = -sLat * cLon;
        phiMatrix[1][1] = -sLat * sLon;
        phiMatrix[1][2] = cLat;
        phiMatrix[2][0] = cLat * cLon;
        phiMatrix[2][1] = cLat * sLon;
        phiMatrix[2][2] = sLat;
        return phiMatrix;
    }

    private static double[][] createTransposedPhiTransform(double originLon, double originLat, double[][] phiMatrix) {
        if (phiMatrix == null) {
            phiMatrix = new double[3][3];
        }
        originLon = Math.PI / 180 * originLon;
        originLat = Math.PI / 180 * originLat;
        double sLat = SloppyMath.sin(originLat);
        double cLat = SloppyMath.cos(originLat);
        double sLon = SloppyMath.sin(originLon);
        double cLon = SloppyMath.cos(originLon);
        phiMatrix[0][0] = -sLon;
        phiMatrix[1][0] = cLon;
        phiMatrix[2][0] = 0.0;
        phiMatrix[0][1] = -sLat * cLon;
        phiMatrix[1][1] = -sLat * sLon;
        phiMatrix[2][1] = cLat;
        phiMatrix[0][2] = cLat * cLon;
        phiMatrix[1][2] = cLat * sLon;
        phiMatrix[2][2] = sLat;
        return phiMatrix;
    }

    public static final double[] pointFromLonLatBearingVincenty(double lon, double lat, double bearing, double dist, double[] pt) {
        double sigmaP;
        double cosSigma;
        double cos2SigmaM;
        double sinSigma;
        double deltaSigma;
        if (pt == null) {
            pt = new double[2];
        }
        double alpha1 = Math.PI / 180 * bearing;
        double cosA1 = SloppyMath.cos(alpha1);
        double sinA1 = SloppyMath.sin(alpha1);
        double tanU1 = 0.9966471893352525 * SloppyMath.tan(Math.PI / 180 * lat);
        double cosU1 = 1.0 / StrictMath.sqrt(1.0 + tanU1 * tanU1);
        double sinU1 = tanU1 * cosU1;
        double sig1 = StrictMath.atan2(tanU1, cosA1);
        double sinAlpha = cosU1 * sinA1;
        double cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
        double uSq = cosSqAlpha * 0.006739496742276434;
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double sigma = dist / (6356752.314245179 * A);
        do {
            cos2SigmaM = SloppyMath.cos(2.0 * sig1 + sigma);
        } while (StrictMath.abs((sigma = dist / (6356752.314245179 * A) + (deltaSigma = B * (sinSigma = SloppyMath.sin(sigma)) * (cos2SigmaM + B / 4.0 * ((cosSigma = SloppyMath.cos(sigma)) * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM))))) - (sigmaP = sigma)) > 1.0E-12);
        double tmp = sinU1 * sinSigma - cosU1 * cosSigma * cosA1;
        double lat2 = StrictMath.atan2(sinU1 * cosSigma + cosU1 * sinSigma * cosA1, 0.9966471893352525 * StrictMath.sqrt(sinAlpha * sinAlpha + tmp * tmp));
        double lambda = StrictMath.atan2(sinSigma * sinA1, cosU1 * cosSigma - sinU1 * sinSigma * cosA1);
        double c = 2.0955066654671753E-4 * cosSqAlpha * (4.0 + 0.0033528106647474805 * (4.0 - 3.0 * cosSqAlpha));
        double lam = lambda - (1.0 - c) * 0.0033528106647474805 * sinAlpha * (sigma + c * sinSigma * (cos2SigmaM + c * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)));
        pt[0] = GeoUtils.normalizeLon(lon + 57.29577951308232 * lam);
        pt[1] = GeoUtils.normalizeLat(57.29577951308232 * lat2);
        return pt;
    }

    public static final double[] pointFromLonLatBearingGreatCircle(double lon, double lat, double bearing, double dist, double[] pt) {
        if (pt == null) {
            pt = new double[2];
        }
        lon *= Math.PI / 180;
        double cLat = SloppyMath.cos(lat *= Math.PI / 180);
        double sLat = SloppyMath.sin(lat);
        double sinDoR = SloppyMath.sin(dist / 6378137.0);
        double cosDoR = SloppyMath.cos(dist / 6378137.0);
        pt[1] = SloppyMath.asin(sLat * cosDoR + cLat * sinDoR * SloppyMath.cos(bearing *= Math.PI / 180));
        pt[0] = 57.29577951308232 * (lon + Math.atan2(SloppyMath.sin(bearing) * sinDoR * cLat, cosDoR - sLat * SloppyMath.sin(pt[1])));
        pt[1] = pt[1] * 57.29577951308232;
        return pt;
    }

    public static double bearingGreatCircle(double lon1, double lat1, double lon2, double lat2) {
        double dLon = (lon2 - lon1) * (Math.PI / 180);
        double y = SloppyMath.sin(dLon) * SloppyMath.cos(lat2 *= Math.PI / 180);
        double x = SloppyMath.cos(lat1 *= Math.PI / 180) * SloppyMath.sin(lat2) - SloppyMath.sin(lat1) * SloppyMath.cos(lat2) * SloppyMath.cos(dLon);
        return Math.atan2(y, x) * 57.29577951308232;
    }
}

