/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import com.google.common.collect.ObjectArrays;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;

public class GetSnapshotsRequestBuilder
extends MasterNodeOperationRequestBuilder<GetSnapshotsRequest, GetSnapshotsResponse, GetSnapshotsRequestBuilder> {
    public GetSnapshotsRequestBuilder(ElasticsearchClient client, GetSnapshotsAction action) {
        super(client, action, new GetSnapshotsRequest());
    }

    public GetSnapshotsRequestBuilder(ElasticsearchClient client, GetSnapshotsAction action, String repository) {
        super(client, action, new GetSnapshotsRequest(repository));
    }

    public GetSnapshotsRequestBuilder setRepository(String repository) {
        ((GetSnapshotsRequest)this.request).repository(repository);
        return this;
    }

    public GetSnapshotsRequestBuilder setSnapshots(String ... snapshots) {
        ((GetSnapshotsRequest)this.request).snapshots(snapshots);
        return this;
    }

    public GetSnapshotsRequestBuilder setCurrentSnapshot() {
        ((GetSnapshotsRequest)this.request).snapshots(new String[]{"_current"});
        return this;
    }

    public GetSnapshotsRequestBuilder addSnapshots(String ... snapshots) {
        ((GetSnapshotsRequest)this.request).snapshots(ObjectArrays.concat(((GetSnapshotsRequest)this.request).snapshots(), snapshots, String.class));
        return this;
    }

    public GetSnapshotsRequestBuilder setIgnoreUnavailable(boolean ignoreUnavailable) {
        ((GetSnapshotsRequest)this.request).ignoreUnavailable(ignoreUnavailable);
        return this;
    }
}

