/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cli;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.elasticsearch.common.cli.CliToolConfig;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.internal.InternalSettingsPreparer;

public abstract class CliTool {
    protected final Terminal terminal;
    protected final Environment env;
    protected final Settings settings;
    private final CliToolConfig config;

    protected CliTool(CliToolConfig config) {
        this(config, Terminal.DEFAULT);
    }

    protected CliTool(CliToolConfig config, Terminal terminal) {
        Preconditions.checkArgument(config.cmds().size() != 0, "At least one command must be configured");
        this.config = config;
        this.terminal = terminal;
        this.env = InternalSettingsPreparer.prepareEnvironment(Settings.Builder.EMPTY_SETTINGS, terminal);
        this.settings = this.env.settings();
    }

    public final ExitStatus execute(String ... args) {
        CliToolConfig.Cmd cmd;
        if (!this.config.isSingle() && args.length > 0 && (args[0].equals("-h") || args[0].equals("--help"))) {
            this.config.printUsage(this.terminal);
            return ExitStatus.OK_AND_EXIT;
        }
        if (this.config.isSingle()) {
            cmd = this.config.single();
        } else {
            if (args.length == 0) {
                this.terminal.printError("command not specified", new Object[0]);
                this.config.printUsage(this.terminal);
                return ExitStatus.USAGE;
            }
            String cmdName = args[0];
            cmd = this.config.cmd(cmdName);
            if (cmd == null) {
                this.terminal.printError("unknown command [%s]. Use [-h] option to list available commands", cmdName);
                return ExitStatus.USAGE;
            }
            if (args.length == 1) {
                args = new String[]{};
            } else {
                String[] cmdArgs = new String[args.length - 1];
                System.arraycopy(args, 1, cmdArgs, 0, cmdArgs.length);
                args = cmdArgs;
            }
        }
        Command command = null;
        try {
            command = this.parse(cmd, args);
            return command.execute(this.settings, this.env);
        }
        catch (IOException ioe) {
            this.terminal.printError(ioe);
            return ExitStatus.IO_ERROR;
        }
        catch (IllegalArgumentException ilae) {
            this.terminal.printError(ilae);
            return ExitStatus.USAGE;
        }
        catch (Throwable t) {
            this.terminal.printError(t);
            if (command == null) {
                return ExitStatus.USAGE;
            }
            return ExitStatus.CODE_ERROR;
        }
    }

    public Command parse(String cmdName, String[] args) throws Exception {
        CliToolConfig.Cmd cmd = this.config.cmd(cmdName);
        return this.parse(cmd, args);
    }

    public Command parse(CliToolConfig.Cmd cmd, String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        CommandLine cli = parser.parse(CliToolConfig.OptionsSource.HELP.options(), args, true);
        if (cli.hasOption("h")) {
            return this.helpCmd(cmd);
        }
        cli = parser.parse(cmd.options(), args, cmd.isStopAtNonOption());
        Terminal.Verbosity verbosity = Terminal.Verbosity.resolve(cli);
        this.terminal.verbosity(verbosity);
        return this.parse(cmd.name(), cli);
    }

    protected Command.Help helpCmd(CliToolConfig.Cmd cmd) {
        return new Command.Help(cmd, this.terminal);
    }

    protected static Command.Exit exitCmd(ExitStatus status) {
        return new Command.Exit(null, status, null);
    }

    protected static Command.Exit exitCmd(ExitStatus status, Terminal terminal, String msg, Object ... args) {
        return new Command.Exit(String.format(Locale.ROOT, msg, args), status, terminal);
    }

    protected abstract Command parse(String var1, CommandLine var2) throws Exception;

    public static abstract class Command {
        protected final Terminal terminal;

        protected Command(Terminal terminal) {
            this.terminal = terminal;
        }

        public abstract ExitStatus execute(Settings var1, Environment var2) throws Exception;

        public static class Exit
        extends Command {
            private final String msg;
            private final ExitStatus status;

            private Exit(String msg, ExitStatus status, Terminal terminal) {
                super(terminal);
                this.msg = msg;
                this.status = status;
            }

            @Override
            public ExitStatus execute(Settings settings, Environment env) throws Exception {
                if (this.msg != null) {
                    if (this.status != ExitStatus.OK) {
                        this.terminal.printError(this.msg, new Object[0]);
                    } else {
                        this.terminal.println(this.msg, new Object[0]);
                    }
                }
                return this.status;
            }

            public ExitStatus status() {
                return this.status;
            }
        }

        public static class Help
        extends Command {
            private final CliToolConfig.Cmd cmd;

            private Help(CliToolConfig.Cmd cmd, Terminal terminal) {
                super(terminal);
                this.cmd = cmd;
            }

            @Override
            public ExitStatus execute(Settings settings, Environment env) throws Exception {
                this.cmd.printUsage(this.terminal);
                return ExitStatus.OK_AND_EXIT;
            }
        }
    }

    public static enum ExitStatus {
        OK(0),
        OK_AND_EXIT(0),
        USAGE(64),
        DATA_ERROR(65),
        NO_INPUT(66),
        NO_USER(67),
        NO_HOST(68),
        UNAVAILABLE(69),
        CODE_ERROR(70),
        CANT_CREATE(73),
        IO_ERROR(74),
        TEMP_FAILURE(75),
        PROTOCOL(76),
        NOPERM(77),
        CONFIG(78);

        final int status;

        private ExitStatus(int status) {
            this.status = status;
        }

        public int status() {
            return this.status;
        }

        public static ExitStatus fromStatus(int status) {
            for (ExitStatus exitStatus : ExitStatus.values()) {
                if (exitStatus.status() != status) continue;
                return exitStatus;
            }
            return null;
        }
    }
}

