/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty;

import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.transport.netty.NettyInternalESLoggerFactory;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;

public class NettyUtils {
    public static final boolean DEFAULT_GATHERING;
    private static EsThreadNameDeterminer ES_THREAD_NAME_DETERMINER;

    public static void setup() {
    }

    static {
        ES_THREAD_NAME_DETERMINER = new EsThreadNameDeterminer();
        InternalLoggerFactory.setDefaultFactory(new NettyInternalESLoggerFactory(){

            @Override
            public InternalLogger newInstance(String name) {
                return super.newInstance(name.replace("org.jboss.netty.", "netty.").replace("org.jboss.netty.", "netty."));
            }
        });
        ThreadRenamingRunnable.setThreadNameDeterminer(ES_THREAD_NAME_DETERMINER);
        DEFAULT_GATHERING = Booleans.parseBoolean(System.getProperty("es.netty.gathering"), true);
        Loggers.getLogger(NettyUtils.class).debug("using gathering [{}]", DEFAULT_GATHERING);
    }

    public static class EsThreadNameDeterminer
    implements ThreadNameDeterminer {
        @Override
        public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
            return currentThreadName + "{" + proposedThreadName + "}";
        }
    }
}

