/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support.filtering;

import com.fasterxml.jackson.core.filter.TokenFilter;
import java.util.ArrayList;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.support.filtering.FilterPath;

public class FilterPathBasedFilter
extends TokenFilter {
    private static final TokenFilter MATCHING = new TokenFilter(){};
    private static final TokenFilter NO_MATCHING = new TokenFilter(){};
    private final FilterPath[] filters;

    public FilterPathBasedFilter(FilterPath[] filters) {
        if (CollectionUtils.isEmpty(filters)) {
            throw new IllegalArgumentException("filters cannot be null or empty");
        }
        this.filters = filters;
    }

    public FilterPathBasedFilter(String[] filters) {
        this(FilterPath.compile(filters));
    }

    private TokenFilter evaluate(String name, FilterPath[] filters) {
        if (filters != null) {
            ArrayList<FilterPath> nextFilters = null;
            for (FilterPath filter : filters) {
                FilterPath next = filter.matchProperty(name);
                if (next == null) continue;
                if (next.matches()) {
                    return MATCHING;
                }
                if (nextFilters == null) {
                    nextFilters = new ArrayList<FilterPath>();
                }
                if (filter.isDoubleWildcard()) {
                    nextFilters.add(filter);
                }
                nextFilters.add(next);
            }
            if (nextFilters != null && !nextFilters.isEmpty()) {
                return new FilterPathBasedFilter(nextFilters.toArray(new FilterPath[nextFilters.size()]));
            }
        }
        return NO_MATCHING;
    }

    @Override
    public TokenFilter includeProperty(String name) {
        TokenFilter include = this.evaluate(name, this.filters);
        if (include == MATCHING) {
            return TokenFilter.INCLUDE_ALL;
        }
        if (include == NO_MATCHING) {
            return null;
        }
        return include;
    }

    @Override
    protected boolean _includeScalar() {
        for (FilterPath filter : this.filters) {
            if (!filter.matches()) continue;
            return true;
        }
        return false;
    }
}

