/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty;

import java.util.List;
import org.elasticsearch.common.netty.NettyUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.CompositeChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;

public class ESHttpResponseEncoder
extends HttpResponseEncoder {
    @Override
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        CompositeChannelBuffer ccb;
        Object retVal = super.encode(ctx, channel, msg);
        if (retVal instanceof CompositeChannelBuffer && (ccb = (CompositeChannelBuffer)retVal).useGathering() != NettyUtils.DEFAULT_GATHERING) {
            List<ChannelBuffer> decompose = ccb.decompose(ccb.readerIndex(), ccb.readableBytes());
            return ChannelBuffers.wrappedBuffer(NettyUtils.DEFAULT_GATHERING, decompose.toArray(new ChannelBuffer[decompose.size()]));
        }
        return retVal;
    }
}

