/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.request;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class RequestCacheStats
implements Streamable,
ToXContent {
    long memorySize;
    long evictions;
    long hitCount;
    long missCount;

    public RequestCacheStats() {
    }

    public RequestCacheStats(long memorySize, long evictions, long hitCount, long missCount) {
        this.memorySize = memorySize;
        this.evictions = evictions;
        this.hitCount = hitCount;
        this.missCount = missCount;
    }

    public void add(RequestCacheStats stats) {
        this.memorySize += stats.memorySize;
        this.evictions += stats.evictions;
        this.hitCount += stats.hitCount;
        this.missCount += stats.missCount;
    }

    public long getMemorySizeInBytes() {
        return this.memorySize;
    }

    public ByteSizeValue getMemorySize() {
        return new ByteSizeValue(this.memorySize);
    }

    public long getEvictions() {
        return this.evictions;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.memorySize = in.readVLong();
        this.evictions = in.readVLong();
        this.hitCount = in.readVLong();
        this.missCount = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.memorySize);
        out.writeVLong(this.evictions);
        out.writeVLong(this.hitCount);
        out.writeVLong(this.missCount);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.REQUEST_CACHE_STATS);
        builder.byteSizeField(Fields.MEMORY_SIZE_IN_BYTES, Fields.MEMORY_SIZE, this.memorySize);
        builder.field(Fields.EVICTIONS, this.getEvictions());
        builder.field(Fields.HIT_COUNT, this.getHitCount());
        builder.field(Fields.MISS_COUNT, this.getMissCount());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString REQUEST_CACHE_STATS = new XContentBuilderString("request_cache");
        static final XContentBuilderString MEMORY_SIZE = new XContentBuilderString("memory_size");
        static final XContentBuilderString MEMORY_SIZE_IN_BYTES = new XContentBuilderString("memory_size_in_bytes");
        static final XContentBuilderString EVICTIONS = new XContentBuilderString("evictions");
        static final XContentBuilderString HIT_COUNT = new XContentBuilderString("hit_count");
        static final XContentBuilderString MISS_COUNT = new XContentBuilderString("miss_count");

        Fields() {
        }
    }
}

