/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

public final class Mapping
implements ToXContent {
    public static final Set<String> LEGACY_INCLUDE_IN_OBJECT = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("_all", "_id", "_parent", "_routing", "_timestamp", "_ttl")));
    final Version indexCreated;
    final RootObjectMapper root;
    final MetadataFieldMapper[] metadataMappers;
    final ImmutableMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappersMap;
    final SourceTransform[] sourceTransforms;
    final ImmutableMap<String, Object> meta;

    public Mapping(Version indexCreated, RootObjectMapper rootObjectMapper, MetadataFieldMapper[] metadataMappers, SourceTransform[] sourceTransforms, ImmutableMap<String, Object> meta) {
        this.indexCreated = indexCreated;
        this.metadataMappers = metadataMappers;
        ImmutableMap.Builder<Class<?>, MetadataFieldMapper> builder = ImmutableMap.builder();
        for (MetadataFieldMapper metadataMapper : metadataMappers) {
            if (indexCreated.before(Version.V_2_0_0_beta1) && LEGACY_INCLUDE_IN_OBJECT.contains(metadataMapper.name())) {
                rootObjectMapper = rootObjectMapper.copyAndPutMapper(metadataMapper);
            }
            builder.put(metadataMapper.getClass(), metadataMapper);
        }
        this.root = rootObjectMapper;
        Arrays.sort(metadataMappers, new Comparator<Mapper>(){

            @Override
            public int compare(Mapper o1, Mapper o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        this.metadataMappersMap = builder.build();
        this.sourceTransforms = sourceTransforms;
        this.meta = meta;
    }

    public RootObjectMapper root() {
        return this.root;
    }

    public Mapping mappingUpdate(Mapper rootObjectMapper) {
        return new Mapping(this.indexCreated, (RootObjectMapper)rootObjectMapper, this.metadataMappers, this.sourceTransforms, this.meta);
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> clazz) {
        return (T)this.metadataMappersMap.get(clazz);
    }

    public Mapping merge(Mapping mergeWith, boolean updateAllTypes) {
        RootObjectMapper mergedRoot = this.root.merge(mergeWith.root, updateAllTypes);
        HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> mergedMetaDataMappers = new HashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>(this.metadataMappersMap);
        for (MetadataFieldMapper metaMergeWith : mergeWith.metadataMappers) {
            MetadataFieldMapper mergeInto = (MetadataFieldMapper)mergedMetaDataMappers.get(metaMergeWith.getClass());
            MetadataFieldMapper merged = mergeInto == null ? metaMergeWith : mergeInto.merge(metaMergeWith, updateAllTypes);
            mergedMetaDataMappers.put(merged.getClass(), merged);
        }
        return new Mapping(this.indexCreated, mergedRoot, mergedMetaDataMappers.values().toArray(new MetadataFieldMapper[0]), this.sourceTransforms, mergeWith.meta);
    }

    public Mapping updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        MetadataFieldMapper[] updatedMeta = Arrays.copyOf(this.metadataMappers, this.metadataMappers.length);
        for (int i = 0; i < updatedMeta.length; ++i) {
            updatedMeta[i] = (MetadataFieldMapper)updatedMeta[i].updateFieldType((Map)fullNameToFieldType);
        }
        ObjectMapper updatedRoot = this.root.updateFieldType((Map)fullNameToFieldType);
        return new Mapping(this.indexCreated, (RootObjectMapper)updatedRoot, updatedMeta, this.sourceTransforms, this.meta);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.root.toXContent(builder, params, new ToXContent(){

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (Mapping.this.sourceTransforms.length > 0) {
                    if (Mapping.this.sourceTransforms.length == 1) {
                        builder.field("transform");
                        Mapping.this.sourceTransforms[0].toXContent(builder, params);
                    } else {
                        builder.startArray("transform");
                        for (ToXContent toXContent : Mapping.this.sourceTransforms) {
                            toXContent.toXContent(builder, params);
                        }
                        builder.endArray();
                    }
                }
                if (Mapping.this.meta != null && !Mapping.this.meta.isEmpty()) {
                    builder.field("_meta", Mapping.this.meta);
                }
                for (ToXContent toXContent : Mapping.this.metadataMappers) {
                    toXContent.toXContent(builder, params);
                }
                return builder;
            }
        });
        return builder;
    }

    public BytesReference toBytes() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            this.toXContent(builder, new ToXContent.MapParams(ImmutableMap.of()));
            return builder.endObject().bytes();
        }
        catch (IOException bogus) {
            throw new AssertionError((Object)bogus);
        }
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            this.toXContent(builder, new ToXContent.MapParams(ImmutableMap.of()));
            return builder.endObject().string();
        }
        catch (IOException bogus) {
            throw new AssertionError((Object)bogus);
        }
    }

    public static interface SourceTransform
    extends ToXContent {
        public Map<String, Object> transformSourceAsMap(Map<String, Object> var1);
    }
}

