/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;

public class SourceFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_source";
    public static final String CONTENT_TYPE = "_source";
    private final boolean enabled;
    private final boolean complete;
    private Boolean compress;
    private long compressThreshold;
    private final String[] includes;
    private final String[] excludes;
    private String format;
    private XContentType formatContentType;

    private SourceFieldMapper(Settings indexSettings) {
        this(true, Defaults.FORMAT, null, -1L, null, null, indexSettings);
    }

    private SourceFieldMapper(boolean enabled, String format, Boolean compress, long compressThreshold, String[] includes, String[] excludes, Settings indexSettings) {
        super("_source", Defaults.FIELD_TYPE.clone(), Defaults.FIELD_TYPE, indexSettings);
        this.enabled = enabled;
        this.compress = compress;
        this.compressThreshold = compressThreshold;
        this.includes = includes;
        this.excludes = excludes;
        this.format = format;
        this.formatContentType = format == null ? null : XContentType.fromRestContentType(format);
        this.complete = enabled && includes == null && excludes == null;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String[] excludes() {
        return this.excludes != null ? this.excludes : Strings.EMPTY_ARRAY;
    }

    public String[] includes() {
        return this.includes != null ? this.includes : Strings.EMPTY_ARRAY;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        boolean filtered;
        if (!this.enabled) {
            return;
        }
        if (!this.fieldType().stored()) {
            return;
        }
        if (context.flyweight()) {
            return;
        }
        BytesReference source = context.source();
        boolean bl = filtered = this.includes != null && this.includes.length > 0 || this.excludes != null && this.excludes.length > 0;
        if (filtered) {
            XContentType contentType;
            BytesStreamOutput bStream;
            Tuple<XContentType, Map<String, Object>> mapTuple = XContentHelper.convertToMap(source, true);
            Map<String, Object> filteredSource = XContentMapValues.filter(mapTuple.v2(), this.includes, this.excludes);
            StreamOutput streamOutput = bStream = new BytesStreamOutput();
            if (this.compress != null && this.compress.booleanValue() && (this.compressThreshold == -1L || (long)source.length() > this.compressThreshold)) {
                streamOutput = CompressorFactory.defaultCompressor().streamOutput(bStream);
            }
            if ((contentType = this.formatContentType) == null) {
                contentType = mapTuple.v1();
            }
            XContentBuilder builder = XContentFactory.contentBuilder(contentType, streamOutput).map(filteredSource);
            builder.close();
            source = bStream.bytes();
        } else if (this.compress != null && this.compress.booleanValue() && !CompressorFactory.isCompressed(source)) {
            if (this.compressThreshold == -1L || (long)source.length() > this.compressThreshold) {
                BytesStreamOutput bStream = new BytesStreamOutput();
                XContentType contentType = XContentFactory.xContentType(source);
                if (this.formatContentType != null && this.formatContentType != contentType) {
                    XContentBuilder builder = XContentFactory.contentBuilder(this.formatContentType, CompressorFactory.defaultCompressor().streamOutput(bStream));
                    builder.copyCurrentStructure(XContentFactory.xContent(contentType).createParser(source));
                    builder.close();
                } else {
                    StreamOutput streamOutput = CompressorFactory.defaultCompressor().streamOutput(bStream);
                    source.writeTo(streamOutput);
                    streamOutput.close();
                }
                source = bStream.bytes();
                context.source(source);
            }
        } else if (this.formatContentType != null) {
            Compressor compressor = CompressorFactory.compressor(source);
            if (compressor != null) {
                XContentType contentType;
                InputStream compressedStreamInput = compressor.streamInput(source.streamInput());
                if (!compressedStreamInput.markSupported()) {
                    compressedStreamInput = new BufferedInputStream(compressedStreamInput);
                }
                if ((contentType = XContentFactory.xContentType(compressedStreamInput)) != this.formatContentType) {
                    BytesStreamOutput bStream = new BytesStreamOutput();
                    StreamOutput streamOutput = CompressorFactory.defaultCompressor().streamOutput(bStream);
                    XContentBuilder builder = XContentFactory.contentBuilder(this.formatContentType, streamOutput);
                    builder.copyCurrentStructure(XContentFactory.xContent(contentType).createParser(compressedStreamInput));
                    builder.close();
                    source = bStream.bytes();
                    context.source(source);
                } else {
                    compressedStreamInput.close();
                }
            } else {
                XContentType contentType = XContentFactory.xContentType(source);
                if (contentType != this.formatContentType) {
                    BytesStreamOutput bStream = new BytesStreamOutput();
                    XContentBuilder builder = XContentFactory.contentBuilder(this.formatContentType, bStream);
                    builder.copyCurrentStructure(XContentFactory.xContent(contentType).createParser(source));
                    builder.close();
                    source = bStream.bytes();
                    context.source(source);
                }
            }
        }
        if (!source.hasArray()) {
            source = source.toBytesArray();
        }
        fields.add(new StoredField(this.fieldType().names().indexName(), source.array(), source.arrayOffset(), source.length()));
    }

    @Override
    protected String contentType() {
        return "_source";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.enabled && this.compress == null && this.compressThreshold == -1L && this.includes == null && this.excludes == null) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (includeDefaults || !this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (includeDefaults || !Objects.equals(this.format, Defaults.FORMAT)) {
            builder.field("format", this.format);
        }
        if (this.compress != null) {
            builder.field("compress", (Object)this.compress);
        } else if (includeDefaults) {
            builder.field("compress", false);
        }
        if (this.compressThreshold != -1L) {
            builder.field("compress_threshold", new ByteSizeValue(this.compressThreshold).toString());
        } else if (includeDefaults) {
            builder.field("compress_threshold", -1);
        }
        if (this.includes != null) {
            builder.field("includes", this.includes);
        } else if (includeDefaults) {
            builder.field("includes", Strings.EMPTY_ARRAY);
        }
        if (this.excludes != null) {
            builder.field("excludes", this.excludes);
        } else if (includeDefaults) {
            builder.field("excludes", Strings.EMPTY_ARRAY);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        SourceFieldMapper sourceMergeWith = (SourceFieldMapper)mergeWith;
        ArrayList<String> conflicts = new ArrayList<String>();
        if (this.enabled != sourceMergeWith.enabled) {
            conflicts.add("Cannot update enabled setting for [_source]");
        }
        if (!Arrays.equals(this.includes(), sourceMergeWith.includes())) {
            conflicts.add("Cannot update includes setting for [_source]");
        }
        if (!Arrays.equals(this.excludes(), sourceMergeWith.excludes())) {
            conflicts.add("Cannot update excludes setting for [_source]");
        }
        if (!conflicts.isEmpty()) {
            throw new IllegalArgumentException("Can't merge because of conflicts: " + conflicts);
        }
        if (sourceMergeWith.compress != null) {
            this.compress = sourceMergeWith.compress;
        }
        if (sourceMergeWith.compressThreshold != -1L) {
            this.compressThreshold = sourceMergeWith.compressThreshold;
        }
    }

    static final class SourceFieldType
    extends MappedFieldType {
        public SourceFieldType() {
        }

        protected SourceFieldType(SourceFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new SourceFieldType(this);
        }

        @Override
        public String typeName() {
            return "_source";
        }

        public byte[] value(Object value) {
            if (value == null) {
                return null;
            }
            BytesReference bValue = value instanceof BytesRef ? new BytesArray((BytesRef)value) : (BytesReference)value;
            try {
                return CompressorFactory.uncompressIfNeeded(bValue).toBytes();
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
            }
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                int i;
                List values;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                    iterator.remove();
                    continue;
                }
                if (fieldName.equals("compress") && parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                    if (fieldNode != null) {
                        builder.compress(XContentMapValues.nodeBooleanValue(fieldNode));
                    }
                    iterator.remove();
                    continue;
                }
                if (fieldName.equals("compress_threshold") && parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                    if (fieldNode != null) {
                        if (fieldNode instanceof Number) {
                            builder.compressThreshold(((Number)fieldNode).longValue());
                            builder.compress(true);
                        } else {
                            builder.compressThreshold(ByteSizeValue.parseBytesSizeValue(fieldNode.toString(), "compress_threshold").bytes());
                            builder.compress(true);
                        }
                    }
                    iterator.remove();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    builder.format(XContentMapValues.nodeStringValue(fieldNode, null));
                    iterator.remove();
                    continue;
                }
                if (fieldName.equals("includes")) {
                    values = (List)fieldNode;
                    String[] includes = new String[values.size()];
                    for (i = 0; i < includes.length; ++i) {
                        includes[i] = values.get(i).toString();
                    }
                    builder.includes(includes);
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("excludes")) continue;
                values = (List)fieldNode;
                String[] excludes = new String[values.size()];
                for (i = 0; i < excludes.length; ++i) {
                    excludes[i] = values.get(i).toString();
                }
                builder.excludes(excludes);
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new SourceFieldMapper(indexSettings);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, SourceFieldMapper> {
        private boolean enabled = true;
        private long compressThreshold = -1L;
        private Boolean compress = null;
        private String format = Defaults.FORMAT;
        private String[] includes = null;
        private String[] excludes = null;

        public Builder() {
            super("_source", Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder compress(boolean compress) {
            this.compress = compress;
            return this;
        }

        public Builder compressThreshold(long compressThreshold) {
            this.compressThreshold = compressThreshold;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder includes(String[] includes) {
            this.includes = includes;
            return this;
        }

        public Builder excludes(String[] excludes) {
            this.excludes = excludes;
            return this;
        }

        @Override
        public SourceFieldMapper build(Mapper.BuilderContext context) {
            return new SourceFieldMapper(this.enabled, this.format, this.compress, this.compressThreshold, this.includes, this.excludes, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_source";
        public static final boolean ENABLED = true;
        public static final long COMPRESS_THRESHOLD = -1L;
        public static final String FORMAT = null;
        public static final MappedFieldType FIELD_TYPE = new SourceFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setNames(new MappedFieldType.Names("_source"));
            FIELD_TYPE.freeze();
        }
    }
}

