/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore.random;

import com.google.common.primitives.Longs;
import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.function.RandomScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.internal.SearchContext;

public class RandomScoreFunctionParser
implements ScoreFunctionParser {
    public static String[] NAMES = new String[]{"random_score", "randomScore"};

    @Inject
    public RandomScoreFunctionParser() {
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public ScoreFunction parse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        XContentParser.Token token;
        int seed = -1;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("seed".equals(currentFieldName)) {
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (parser.numberType() == XContentParser.NumberType.INT) {
                        seed = parser.intValue();
                        continue;
                    }
                    if (parser.numberType() == XContentParser.NumberType.LONG) {
                        seed = Longs.hashCode(parser.longValue());
                        continue;
                    }
                    throw new QueryParsingException(parseContext, "random_score seed must be an int, long or string, not '" + token.toString() + "'", new Object[0]);
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    seed = parser.text().hashCode();
                    continue;
                }
                throw new QueryParsingException(parseContext, "random_score seed must be an int/long or string, not '" + token.toString() + "'", new Object[0]);
            }
            throw new QueryParsingException(parseContext, NAMES[0] + " query does not support [" + currentFieldName + "]", new Object[0]);
        }
        MappedFieldType fieldType = SearchContext.current().mapperService().smartNameFieldType("_uid");
        if (fieldType == null) {
            return new RandomScoreFunction();
        }
        if (seed == -1) {
            seed = Longs.hashCode(parseContext.nowInMillis());
        }
        ShardId shardId = SearchContext.current().indexShard().shardId();
        int salt = shardId.index().name().hashCode() << 10 | shardId.id();
        Object uidFieldData = SearchContext.current().fieldData().getForField(fieldType);
        return new RandomScoreFunction(seed, salt, (IndexFieldData<?>)uidFieldData);
    }
}

