/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ExtendedCommonTermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.all.AllTermQuery;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.support.QueryParsers;

public class MatchQuery {
    protected final QueryParseContext parseContext;
    protected String analyzer;
    protected BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
    protected boolean enablePositionIncrements = true;
    protected int phraseSlop = 0;
    protected Fuzziness fuzziness = null;
    protected int fuzzyPrefixLength = 0;
    protected int maxExpansions = 50;
    protected boolean transpositions = true;
    protected MultiTermQuery.RewriteMethod fuzzyRewriteMethod;
    protected boolean lenient;
    protected ZeroTermsQuery zeroTermsQuery = ZeroTermsQuery.NONE;
    protected Float commonTermsCutoff = null;

    public MatchQuery(QueryParseContext parseContext) {
        this.parseContext = parseContext;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public void setOccur(BooleanClause.Occur occur) {
        this.occur = occur;
    }

    public void setCommonTermsCutoff(float cutoff) {
        this.commonTermsCutoff = Float.valueOf(cutoff);
    }

    public void setEnablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public void setFuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public void setTranspositions(boolean transpositions) {
        this.transpositions = transpositions;
    }

    public void setFuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void setZeroTermsQuery(ZeroTermsQuery zeroTermsQuery) {
        this.zeroTermsQuery = zeroTermsQuery;
    }

    protected Analyzer getAnalyzer(MappedFieldType fieldType) {
        if (this.analyzer == null) {
            if (fieldType != null) {
                return this.parseContext.getSearchAnalyzer(fieldType);
            }
            return this.parseContext.mapperService().searchAnalyzer();
        }
        NamedAnalyzer analyzer = this.parseContext.mapperService().analysisService().analyzer(this.analyzer);
        if (analyzer == null) {
            throw new IllegalArgumentException("No analyzer found for [" + this.analyzer + "]");
        }
        return analyzer;
    }

    public Query parse(Type type, String fieldName, Object value) throws IOException {
        boolean noForcedAnalyzer;
        MappedFieldType fieldType = this.parseContext.fieldMapper(fieldName);
        String field = fieldType != null ? fieldType.names().indexName() : fieldName;
        boolean bl = noForcedAnalyzer = this.analyzer == null;
        if (fieldType != null && fieldType.useTermQueryWithQueryString() && noForcedAnalyzer) {
            return this.termQuery(fieldType, value);
        }
        Analyzer analyzer = this.getAnalyzer(fieldType);
        assert (analyzer != null);
        MatchQueryBuilder builder = new MatchQueryBuilder(analyzer, fieldType);
        builder.setEnablePositionIncrements(this.enablePositionIncrements);
        Query query = null;
        switch (type) {
            case BOOLEAN: {
                if (this.commonTermsCutoff == null) {
                    query = builder.createBooleanQuery(field, value.toString(), this.occur);
                    break;
                }
                query = builder.createCommonTermsQuery(field, value.toString(), this.occur, this.occur, this.commonTermsCutoff.floatValue(), fieldType);
                break;
            }
            case PHRASE: {
                query = builder.createPhraseQuery(field, value.toString(), this.phraseSlop);
                break;
            }
            case PHRASE_PREFIX: {
                query = builder.createPhrasePrefixQuery(field, value.toString(), this.phraseSlop, this.maxExpansions);
                break;
            }
            default: {
                throw new IllegalStateException("No type found for [" + (Object)((Object)type) + "]");
            }
        }
        if (query == null) {
            return this.zeroTermsQuery();
        }
        return query;
    }

    protected Query termQuery(MappedFieldType fieldType, Object value) {
        return this.termQuery(fieldType, value, this.lenient);
    }

    protected final Query termQuery(MappedFieldType fieldType, Object value, boolean lenient) {
        try {
            return fieldType.termQuery(value, this.parseContext);
        }
        catch (RuntimeException e) {
            if (lenient) {
                return null;
            }
            throw e;
        }
    }

    protected Query zeroTermsQuery() {
        return this.zeroTermsQuery == ZeroTermsQuery.NONE ? Queries.newMatchNoDocsQuery() : Queries.newMatchAllQuery();
    }

    protected Query blendTermQuery(Term term, MappedFieldType fieldType) {
        Query query;
        if (this.fuzziness != null) {
            if (fieldType != null) {
                try {
                    Query query2 = fieldType.fuzzyQuery(term.text(), this.fuzziness, this.fuzzyPrefixLength, this.maxExpansions, this.transpositions);
                    if (query2 instanceof FuzzyQuery) {
                        QueryParsers.setRewriteMethod((FuzzyQuery)query2, this.fuzzyRewriteMethod);
                    }
                    return query2;
                }
                catch (RuntimeException e) {
                    return new TermQuery(term);
                }
            }
            int edits = this.fuzziness.asDistance(term.text());
            FuzzyQuery query3 = new FuzzyQuery(term, edits, this.fuzzyPrefixLength, this.maxExpansions, this.transpositions);
            QueryParsers.setRewriteMethod(query3, this.fuzzyRewriteMethod);
            return query3;
        }
        if (fieldType != null && (query = this.termQuery(fieldType, term.bytes(), true)) != null) {
            return query;
        }
        return new TermQuery(term);
    }

    private class MatchQueryBuilder
    extends QueryBuilder {
        private final MappedFieldType mapper;

        public MatchQueryBuilder(@Nullable Analyzer analyzer, MappedFieldType mapper) {
            super(analyzer);
            this.mapper = mapper;
        }

        @Override
        protected Query newTermQuery(Term term) {
            return MatchQuery.this.blendTermQuery(term, this.mapper);
        }

        public Query createPhrasePrefixQuery(String field, String queryText, int phraseSlop, int maxExpansions) {
            Query query = this.createFieldQuery(this.getAnalyzer(), BooleanClause.Occur.MUST, field, queryText, true, phraseSlop);
            MultiPhrasePrefixQuery prefixQuery = new MultiPhrasePrefixQuery();
            prefixQuery.setMaxExpansions(maxExpansions);
            prefixQuery.setSlop(phraseSlop);
            if (query instanceof PhraseQuery) {
                PhraseQuery pq = (PhraseQuery)query;
                Term[] terms = pq.getTerms();
                int[] positions = pq.getPositions();
                for (int i = 0; i < terms.length; ++i) {
                    prefixQuery.add(new Term[]{terms[i]}, positions[i]);
                }
                return prefixQuery;
            }
            if (query instanceof MultiPhraseQuery) {
                MultiPhraseQuery pq = (MultiPhraseQuery)query;
                List<Term[]> terms = pq.getTermArrays();
                int[] positions = pq.getPositions();
                for (int i = 0; i < terms.size(); ++i) {
                    prefixQuery.add(terms.get(i), positions[i]);
                }
                return prefixQuery;
            }
            if (query instanceof TermQuery) {
                prefixQuery.add(((TermQuery)query).getTerm());
                return prefixQuery;
            }
            if (query instanceof AllTermQuery) {
                prefixQuery.add(((AllTermQuery)query).getTerm());
                return prefixQuery;
            }
            return query;
        }

        public Query createCommonTermsQuery(String field, String queryText, BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency, MappedFieldType fieldType) {
            Query booleanQuery = this.createBooleanQuery(field, queryText, lowFreqOccur);
            if (booleanQuery != null && booleanQuery instanceof BooleanQuery) {
                BooleanQuery bq = (BooleanQuery)booleanQuery;
                ExtendedCommonTermsQuery query = new ExtendedCommonTermsQuery(highFreqOccur, lowFreqOccur, maxTermFrequency, ((BooleanQuery)booleanQuery).isCoordDisabled(), fieldType);
                for (BooleanClause clause : bq.clauses()) {
                    if (!(clause.getQuery() instanceof TermQuery)) {
                        return booleanQuery;
                    }
                    query.add(((TermQuery)clause.getQuery()).getTerm());
                }
                return query;
            }
            return booleanQuery;
        }
    }

    public static enum ZeroTermsQuery {
        NONE,
        ALL;

    }

    public static enum Type {
        BOOLEAN,
        PHRASE,
        PHRASE_PREFIX;

    }
}

