/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.packed.GrowableWriter;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.index.shard.FilterDocValuesProducer;

class VersionFieldUpgrader
extends FilterCodecReader {
    final FieldInfos infos;

    VersionFieldUpgrader(CodecReader in) {
        super(in);
        int fieldNumber = 0;
        for (FieldInfo fi : in.getFieldInfos()) {
            fieldNumber = Math.max(fieldNumber, fi.number + 1);
        }
        FieldInfo newInfo = new FieldInfo("_version", fieldNumber, false, false, false, IndexOptions.NONE, DocValuesType.NUMERIC, -1L, Collections.emptyMap());
        newInfo.checkConsistency();
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        for (FieldInfo info : in.getFieldInfos()) {
            if (info.name.equals("_version")) continue;
            fieldInfoList.add(info);
        }
        fieldInfoList.add(newInfo);
        this.infos = new FieldInfos(fieldInfoList.toArray(new FieldInfo[fieldInfoList.size()]));
    }

    static CodecReader wrap(CodecReader reader) throws IOException {
        FieldInfos fieldInfos = reader.getFieldInfos();
        FieldInfo versionInfo = fieldInfos.fieldInfo("_version");
        if (versionInfo != null && versionInfo.getDocValuesType() != DocValuesType.NONE) {
            return reader;
        }
        Terms terms = reader.terms("_uid");
        if (terms == null || !terms.hasPayloads()) {
            return reader;
        }
        return new VersionFieldUpgrader(reader);
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.infos;
    }

    @Override
    public DocValuesProducer getDocValuesReader() {
        DocValuesProducer producer = this.in.getDocValuesReader();
        if (producer == null) {
            producer = FilterDocValuesProducer.EMPTY;
        }
        return new UninvertedVersions(producer, this);
    }

    static class UninvertedVersions
    extends FilterDocValuesProducer {
        final CodecReader reader;

        UninvertedVersions(DocValuesProducer in, CodecReader reader) {
            super(in);
            this.reader = reader;
        }

        @Override
        public NumericDocValues getNumeric(FieldInfo field) throws IOException {
            if ("_version".equals(field.name)) {
                Terms terms = this.reader.terms("_uid");
                TermsEnum uids = terms.iterator();
                GrowableWriter versions = new GrowableWriter(2, this.reader.maxDoc(), 0.0f);
                PostingsEnum dpe = null;
                BytesRef uid = uids.next();
                while (uid != null) {
                    dpe = uids.postings(dpe, 88);
                    assert (terms.hasPayloads()) : "field has payloads";
                    Bits liveDocs = this.reader.getLiveDocs();
                    int doc = dpe.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        if (liveDocs == null || liveDocs.get(doc)) {
                            dpe.nextPosition();
                            BytesRef payload = dpe.getPayload();
                            if (payload != null && payload.length == 8) {
                                long version = Numbers.bytesToLong(payload);
                                versions.set(doc, version);
                                break;
                            }
                        }
                        doc = dpe.nextDoc();
                    }
                    uid = uids.next();
                }
                return versions;
            }
            return this.in.getNumeric(field);
        }

        @Override
        public Bits getDocsWithField(FieldInfo field) throws IOException {
            if ("_version".equals(field.name)) {
                return new Bits.MatchAllBits(this.reader.maxDoc());
            }
            return this.in.getDocsWithField(field);
        }

        @Override
        public DocValuesProducer getMergeInstance() throws IOException {
            return new UninvertedVersions(this.in.getMergeInstance(), this.reader);
        }
    }
}

