/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.percolator.PercolateContext;
import org.elasticsearch.percolator.PercolatorIndex;

class SingleDocumentPercolatorIndex
implements PercolatorIndex {
    private final CloseableThreadLocal<MemoryIndex> cache;

    SingleDocumentPercolatorIndex(CloseableThreadLocal<MemoryIndex> cache) {
        this.cache = cache;
    }

    @Override
    public void prepare(PercolateContext context, ParsedDocument parsedDocument) {
        MemoryIndex memoryIndex = this.cache.get();
        for (IndexableField field : parsedDocument.rootDoc().getFields()) {
            if (field.fieldType().indexOptions() == IndexOptions.NONE && field.name().equals("_uid")) continue;
            try {
                Analyzer analyzer = context.mapperService().documentMapper(parsedDocument.type()).mappers().indexAnalyzer();
                TokenStream tokenStream = field.tokenStream(analyzer, null);
                Throwable throwable = null;
                try {
                    if (tokenStream == null) continue;
                    memoryIndex.addField(field.name(), tokenStream, field.boost());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tokenStream == null) continue;
                    if (throwable != null) {
                        try {
                            tokenStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    tokenStream.close();
                }
            }
            catch (Exception e) {
                throw new ElasticsearchException("Failed to create token stream for [" + field.name() + "]", (Throwable)e, new Object[0]);
            }
        }
        context.initialize(new DocEngineSearcher(memoryIndex), parsedDocument);
    }

    private class DocEngineSearcher
    extends Engine.Searcher {
        private final MemoryIndex memoryIndex;

        public DocEngineSearcher(MemoryIndex memoryIndex) {
            super("percolate", memoryIndex.createSearcher());
            this.memoryIndex = memoryIndex;
        }

        @Override
        public void close() {
            try {
                this.reader().close();
                this.memoryIndex.reset();
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to close percolator in-memory index", (Throwable)e, new Object[0]);
            }
        }
    }
}

