/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.spatial.util.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortingNumericDocValues;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridAggregator;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridParams;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoHashGrid;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParser;
import org.elasticsearch.search.internal.SearchContext;

public class GeoHashGridParser
implements Aggregator.Parser {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(GeoHashGridParser.class));

    @Override
    public String type() {
        return InternalGeoHashGrid.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        ValuesSourceParser<ValuesSource.GeoPoint> vsParser = ValuesSourceParser.geoPoint(aggregationName, InternalGeoHashGrid.TYPE, context).build();
        int precision = 5;
        int requiredSize = 10000;
        int shardSize = -1;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (vsParser.token(currentFieldName, token, parser)) continue;
            if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
                if (context.parseFieldMatcher().match(currentFieldName, GeoHashGridParams.FIELD_PRECISION)) {
                    precision = GeoHashGridParams.checkPrecision(parser.intValue());
                    continue;
                }
                if (context.parseFieldMatcher().match(currentFieldName, GeoHashGridParams.FIELD_SIZE)) {
                    requiredSize = parser.intValue();
                    continue;
                }
                if (!context.parseFieldMatcher().match(currentFieldName, GeoHashGridParams.FIELD_SHARD_SIZE)) continue;
                shardSize = parser.intValue();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) continue;
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].", parser.getTokenLocation());
        }
        if (shardSize == 0) {
            shardSize = Integer.MAX_VALUE;
            DEPRECATION_LOGGER.deprecated("shardSize of 0 in aggregations is deprecated and will be invalid in future versions. Please specify a shardSize greater than 0", new Object[0]);
        }
        if (requiredSize == 0) {
            requiredSize = Integer.MAX_VALUE;
            DEPRECATION_LOGGER.deprecated("size of 0 in aggregations is deprecated and will be invalid in future versions. Please specify a size greater than 0", new Object[0]);
        }
        if (shardSize < 0) {
            shardSize = BucketUtils.suggestShardSideQueueSize(requiredSize, context.numberOfShards());
        }
        if (shardSize < requiredSize) {
            shardSize = requiredSize;
        }
        return new GeoGridFactory(aggregationName, vsParser.config(), precision, requiredSize, shardSize);
    }

    static class GeoGridFactory
    extends ValuesSourceAggregatorFactory<ValuesSource.GeoPoint> {
        private final int precision;
        private final int requiredSize;
        private final int shardSize;

        public GeoGridFactory(String name, ValuesSourceConfig<ValuesSource.GeoPoint> config, int precision, int requiredSize, int shardSize) {
            super(name, InternalGeoHashGrid.TYPE.name(), config);
            this.precision = precision;
            this.requiredSize = requiredSize;
            this.shardSize = shardSize;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            final InternalGeoHashGrid aggregation = new InternalGeoHashGrid(this.name, this.requiredSize, Collections.emptyList(), pipelineAggregators, metaData);
            return new NonCollectingAggregator(this.name, aggregationContext, parent, pipelineAggregators, metaData){

                @Override
                public InternalAggregation buildEmptyAggregation() {
                    return aggregation;
                }
            };
        }

        @Override
        protected Aggregator doCreateInternal(ValuesSource.GeoPoint valuesSource, AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            if (!collectsFromSingleBucket) {
                return GeoGridFactory.asMultiBucketAggregator(this, aggregationContext, parent);
            }
            CellIdSource cellIdSource = new CellIdSource(valuesSource, this.precision);
            return new GeoHashGridAggregator(this.name, this.factories, cellIdSource, this.requiredSize, this.shardSize, aggregationContext, parent, pipelineAggregators, metaData);
        }

        static class CellIdSource
        extends ValuesSource.Numeric {
            private final ValuesSource.GeoPoint valuesSource;
            private final int precision;

            public CellIdSource(ValuesSource.GeoPoint valuesSource, int precision) {
                this.valuesSource = valuesSource;
                this.precision = precision;
            }

            public int precision() {
                return this.precision;
            }

            @Override
            public boolean isFloatingPoint() {
                return false;
            }

            @Override
            public SortedNumericDocValues longValues(LeafReaderContext ctx) {
                return new CellValues(this.valuesSource.geoPointValues(ctx), this.precision);
            }

            @Override
            public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
                throw new UnsupportedOperationException();
            }
        }

        private static class CellValues
        extends SortingNumericDocValues {
            private final MultiGeoPointValues geoValues;
            private final int precision;

            protected CellValues(MultiGeoPointValues geoValues, int precision) {
                this.geoValues = geoValues;
                this.precision = precision;
            }

            @Override
            public void setDocument(int docId) {
                this.geoValues.setDocument(docId);
                this.resize(this.geoValues.count());
                for (int i = 0; i < this.count(); ++i) {
                    GeoPoint target = this.geoValues.valueAt(i);
                    this.values[i] = GeoHashUtils.longEncode(target.getLon(), target.getLat(), this.precision);
                }
                this.sort();
            }
        }
    }
}

