/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DiversifiedTopDocsCollector;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.BestDocsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class DiversifiedMapSamplerAggregator
extends SamplerAggregator {
    private ValuesSource valuesSource;
    private int maxDocsPerValue;
    private BytesRefHash bucketOrds;

    public DiversifiedMapSamplerAggregator(String name, int shardSize, AggregatorFactories factories, AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, ValuesSource valuesSource, int maxDocsPerValue) throws IOException {
        super(name, shardSize, factories, aggregationContext, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.maxDocsPerValue = maxDocsPerValue;
        this.bucketOrds = new BytesRefHash(shardSize, aggregationContext.bigArrays());
    }

    @Override
    protected void doClose() {
        Releasables.close(this.bucketOrds);
        super.doClose();
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.bdd = new DiverseDocsDeferringCollector();
        return this.bdd;
    }

    class DiverseDocsDeferringCollector
    extends BestDocsDeferringCollector {
        public DiverseDocsDeferringCollector() {
            super(DiversifiedMapSamplerAggregator.this.shardSize, DiversifiedMapSamplerAggregator.this.context.bigArrays());
        }

        protected TopDocsCollector<DiversifiedTopDocsCollector.ScoreDocKey> createTopDocsCollector(int size) {
            return new ValuesDiversifiedTopDocsCollector(size, DiversifiedMapSamplerAggregator.this.maxDocsPerValue);
        }

        class ValuesDiversifiedTopDocsCollector
        extends DiversifiedTopDocsCollector {
            private SortedBinaryDocValues values;

            public ValuesDiversifiedTopDocsCollector(int numHits, int maxHitsPerKey) {
                super(numHits, maxHitsPerKey);
            }

            @Override
            protected NumericDocValues getKeys(LeafReaderContext context) {
                try {
                    this.values = DiversifiedMapSamplerAggregator.this.valuesSource.bytesValues(context);
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Error reading values", (Throwable)e, new Object[0]);
                }
                return new NumericDocValues(){

                    @Override
                    public long get(int doc) {
                        ValuesDiversifiedTopDocsCollector.this.values.setDocument(doc);
                        int valuesCount = ValuesDiversifiedTopDocsCollector.this.values.count();
                        if (valuesCount > 1) {
                            throw new IllegalArgumentException("Sample diversifying key must be a single valued-field");
                        }
                        if (valuesCount == 1) {
                            BytesRef bytes = ValuesDiversifiedTopDocsCollector.this.values.valueAt(0);
                            long bucketOrdinal = DiversifiedMapSamplerAggregator.this.bucketOrds.add(bytes);
                            if (bucketOrdinal < 0L) {
                                bucketOrdinal = -1L - bucketOrdinal;
                            }
                            return bucketOrdinal;
                        }
                        return 0L;
                    }
                };
            }
        }
    }
}

