/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles.hdr;

import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.AbstractInternalHDRPercentiles;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class InternalHDRPercentileRanks
extends AbstractInternalHDRPercentiles
implements PercentileRanks {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("percentile_ranks", "hdr_percentile_ranks");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalHDRPercentileRanks readResult(StreamInput in) throws IOException {
            InternalHDRPercentileRanks result = new InternalHDRPercentileRanks();
            result.readFrom(in);
            return result;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalHDRPercentileRanks() {
    }

    public InternalHDRPercentileRanks(String name, double[] cdfValues, DoubleHistogram state, boolean keyed, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, cdfValues, state, keyed, formatter, pipelineAggregators, metaData);
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.keys, this.state);
    }

    @Override
    public double percent(double value) {
        return InternalHDRPercentileRanks.percentileRank(this.state, value);
    }

    @Override
    public String percentAsString(double value) {
        return this.valueAsString(String.valueOf(value));
    }

    @Override
    public double value(double key) {
        return this.percent(key);
    }

    @Override
    protected AbstractInternalHDRPercentiles createReduced(String name, double[] keys, DoubleHistogram merged, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        return new InternalHDRPercentileRanks(name, keys, merged, keyed, this.valueFormatter, pipelineAggregators, metaData);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    static double percentileRank(DoubleHistogram state, double value) {
        if (state.getTotalCount() == 0L) {
            return Double.NaN;
        }
        double percentileRank = state.getPercentileAtOrBelowValue(value);
        if (percentileRank < 0.0) {
            percentileRank = 0.0;
        } else if (percentileRank > 100.0) {
            percentileRank = 100.0;
        }
        return percentileRank;
    }

    public static class Iter
    extends UnmodifiableIterator<Percentile> {
        private final double[] values;
        private final DoubleHistogram state;
        private int i;

        public Iter(double[] values, DoubleHistogram state) {
            this.values = values;
            this.state = state;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.values.length;
        }

        @Override
        public Percentile next() {
            InternalPercentile next = new InternalPercentile(InternalHDRPercentileRanks.percentileRank(this.state, this.values[this.i]), this.values[this.i]);
            ++this.i;
            return next;
        }
    }
}

